/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.primitives.Shorts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.network.command.CreatePartitionGroup;
import org.joyqueue.store.StoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CreatePartitionGroupHandler
implements CommandHandler,
Type {
    private static Logger logger = LoggerFactory.getLogger(CreatePartitionGroupHandler.class);
    private ClusterManager clusterManager;
    private ElectionService electionService;
    private StoreService storeService;
    private NameServiceConfig config;

    public CreatePartitionGroupHandler(BrokerContext brokerContext) {
        this.clusterManager = brokerContext.getClusterManager();
        this.electionService = brokerContext.getElectionService();
        this.storeService = brokerContext.getStoreService();
        this.config = new NameServiceConfig(brokerContext.getPropertySupplier());
    }

    public int type() {
        return 127;
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        if (!this.config.getMessengerIgniteEnable()) {
            return BooleanAck.build();
        }
        if (command == null) {
            logger.error("CreatePartitionGroupHandler request command is null");
            return null;
        }
        CreatePartitionGroup request = (CreatePartitionGroup)command.getPayload();
        try {
            PartitionGroup group = request.getPartitionGroup();
            if (logger.isDebugEnabled()) {
                logger.debug("begin createPartitionGroup topic[{}] partitionGroupRequest [{}] ", (Object)group.getTopic(), (Object)JSON.toJSONString((Object)request));
            }
            if (!request.isRollback()) {
                this.commit(group);
            } else {
                this.rollback(group);
            }
            return BooleanAck.build();
        }
        catch (JoyQueueException e) {
            logger.error(String.format("CreatePartitionGroupHandler request command[%s] error", request), (Throwable)e);
            return BooleanAck.build((int)e.getCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error(String.format("CreatePartitionGroupHandler request command[%s] error", request), (Throwable)e);
            return BooleanAck.build((JoyQueueCode)JoyQueueCode.CN_UNKNOWN_ERROR, (Object[])new Object[]{e.getMessage()});
        }
    }

    private void commit(PartitionGroup group) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("topic[{}] add partitionGroup[{}]", (Object)group.getTopic(), (Object)group.getGroup());
        }
        this.storeService.createPartitionGroup(group.getTopic().getFullName(), group.getGroup(), Shorts.toArray((Collection)group.getPartitions()));
        Set replicas = group.getReplicas();
        ArrayList<Broker> list = new ArrayList<Broker>(replicas.size());
        replicas.forEach(brokerId -> list.add(this.clusterManager.getBrokerById((Integer)brokerId)));
        this.electionService.onPartitionGroupCreate(group.getElectType(), group.getTopic(), group.getGroup(), list, group.getLearners(), this.clusterManager.getBrokerId(), group.getLeader());
    }

    private void rollback(PartitionGroup group) {
        if (logger.isDebugEnabled()) {
            logger.debug("topic[{}] remove partitionGroup[{}]", (Object)group.getTopic(), (Object)group.getGroup());
        }
        this.storeService.removePartitionGroup(group.getTopic().getFullName(), group.getGroup());
        this.electionService.onPartitionGroupRemove(group.getTopic(), group.getGroup());
    }
}

