/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.handler;

import java.util.List;
import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.network.BrokerCommandHandler;
import org.joyqueue.broker.network.command.GetPartitionGroupClusterRequest;
import org.joyqueue.broker.network.command.GetPartitionGroupClusterResponse;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.store.StoreNode;
import org.joyqueue.store.StoreNodes;
import org.joyqueue.store.StoreService;

public class GetPartitionGroupClusterRequestHandler
implements Type,
BrokerCommandHandler,
BrokerContextAware {
    private StoreService storeService;

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        this.storeService = brokerContext.getStoreService();
    }

    public Command handle(Transport transport, Command command) {
        GetPartitionGroupClusterRequest request = (GetPartitionGroupClusterRequest)((Object)command.getPayload());
        GetPartitionGroupClusterResponse response = new GetPartitionGroupClusterResponse();
        for (Map.Entry<String, List<Integer>> entry : request.getGroups().entrySet()) {
            String topic = entry.getKey();
            for (Integer partitionGroup : entry.getValue()) {
                StoreNodes nodes = this.storeService.getNodes(topic, partitionGroup.intValue());
                if (nodes == null) continue;
                GetPartitionGroupClusterResponse.PartitionGroupCluster partitionGroupCluster = new GetPartitionGroupClusterResponse.PartitionGroupCluster();
                for (StoreNode node : nodes.getNodes()) {
                    partitionGroupCluster.addNode(new GetPartitionGroupClusterResponse.PartitionGroupNode(node.getId(), node.isWritable(), node.isReadable()));
                }
                response.addCluster(topic, partitionGroup, partitionGroupCluster);
            }
        }
        return new Command((Object)response);
    }

    public int type() {
        return 72;
    }
}

