/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.handler;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.network.command.UpdatePartitionGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PartitionGroupLeaderChangeHandler
implements CommandHandler,
Type {
    private static Logger logger = LoggerFactory.getLogger(PartitionGroupLeaderChangeHandler.class);
    private ElectionService electionService;
    private NameServiceConfig config;

    public PartitionGroupLeaderChangeHandler(BrokerContext brokerContext) {
        this.electionService = brokerContext.getElectionService();
        this.config = new NameServiceConfig(brokerContext.getPropertySupplier());
    }

    public int type() {
        return 124;
    }

    public Command handle(Transport transport, Command command) {
        if (!this.config.getMessengerIgniteEnable()) {
            return BooleanAck.build();
        }
        if (command == null) {
            logger.error("PartitionGroupLeaderChangeHandler request command is null");
            return null;
        }
        UpdatePartitionGroup request = (UpdatePartitionGroup)command.getPayload();
        PartitionGroup group = request.getPartitionGroup();
        try {
            this.electionService.onLeaderChange(group.getTopic(), group.getGroup(), group.getLeader());
        }
        catch (Exception e) {
            logger.error(String.format("PartitionGroupLeaderChangeHandler request command[%s] error", command.getPayload()), (Throwable)e);
            return BooleanAck.build((JoyQueueCode)JoyQueueCode.CN_UNKNOWN_ERROR, (Object[])new Object[]{e.getMessage()});
        }
        return BooleanAck.build();
    }
}

