/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.handler;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.network.command.RemovePartitionGroup;
import org.joyqueue.store.StoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RemovePartitionGroupHandler
implements CommandHandler,
Type {
    private static Logger logger = LoggerFactory.getLogger(RemovePartitionGroupHandler.class);
    private ElectionService electionService;
    private StoreService storeService;
    private NameServiceConfig config;

    public RemovePartitionGroupHandler(BrokerContext brokerContext) {
        this.electionService = brokerContext.getElectionService();
        this.storeService = brokerContext.getStoreService();
        this.config = new NameServiceConfig(brokerContext.getPropertySupplier());
    }

    public int type() {
        return 125;
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        if (!this.config.getMessengerIgniteEnable()) {
            return BooleanAck.build();
        }
        if (command == null) {
            logger.error("CreatePartitionGroupHandler request command is null");
            return null;
        }
        RemovePartitionGroup request = (RemovePartitionGroup)command.getPayload();
        PartitionGroup group = request.getPartitionGroup();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("begin removePartitionGroup topic[{}] partitionGroupRequest [{}] ", (Object)group.getTopic(), (Object)request);
            }
            this.commit(group);
            return BooleanAck.build();
        }
        catch (Exception e) {
            logger.error(String.format("removePartitionGroup topic[{}] partitionGroupRequest [{}] error", group.getTopic(), request), (Throwable)e);
            return BooleanAck.build((JoyQueueCode)JoyQueueCode.CN_UNKNOWN_ERROR, (Object[])new Object[]{e.getMessage()});
        }
    }

    private void commit(PartitionGroup group) {
        if (logger.isDebugEnabled()) {
            logger.debug("topic[{}] remove partitionGroup[{}]", (Object)group.getTopic(), (Object)group.getGroup());
        }
        this.storeService.removePartitionGroup(group.getTopic().getFullName(), group.getGroup());
        this.electionService.onPartitionGroupRemove(group.getTopic(), group.getGroup());
    }

    private void rollback(Transport transport, Command command) {
    }
}

