/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.primitives.Shorts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.handler.CreatePartitionGroupHandler;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.network.command.UpdatePartitionGroup;
import org.joyqueue.store.StoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class UpdatePartitionGroupHandler
implements CommandHandler,
Type {
    private static Logger logger = LoggerFactory.getLogger(CreatePartitionGroupHandler.class);
    private ClusterManager clusterManager;
    private ElectionService electionService;
    private StoreService storeService;
    private NameServiceConfig config;

    public UpdatePartitionGroupHandler(BrokerContext brokerContext) {
        this.clusterManager = brokerContext.getClusterManager();
        this.electionService = brokerContext.getElectionService();
        this.storeService = brokerContext.getStoreService();
        this.config = new NameServiceConfig(brokerContext.getPropertySupplier());
    }

    public int type() {
        return 126;
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        if (!this.config.getMessengerIgniteEnable()) {
            return BooleanAck.build();
        }
        if (command == null) {
            logger.error("UpdatePartitionGroupHandler request command is null");
            return null;
        }
        UpdatePartitionGroup request = (UpdatePartitionGroup)command.getPayload();
        PartitionGroup groupNew = request.getPartitionGroup();
        PartitionGroup groupOld = this.clusterManager.getNameService().getTopicConfig(groupNew.getTopic()).fetchPartitionGroupByGroup(groupNew.getGroup());
        try {
            TreeSet<Integer> replicasNew = new TreeSet<Integer>(groupNew.getReplicas());
            TreeSet<Integer> replicasOld = new TreeSet<Integer>(groupOld.getReplicas());
            replicasNew.removeAll(groupOld.getReplicas());
            replicasOld.removeAll(groupNew.getReplicas());
            Integer localBrokerId = this.clusterManager.getBrokerId();
            logger.info("begin updatePartitionGroup topic[{}] from [{}] to [{}] addNode[{}] removeNode[{}] localNode[{}]", new Object[]{groupNew.getTopic(), JSON.toJSONString((Object)groupOld), JSON.toJSONString((Object)groupNew), Arrays.toString(replicasNew.toArray()), Arrays.toString(replicasOld.toArray())});
            if (!request.isRollback()) {
                this.commit(groupNew, groupOld, replicasNew, replicasOld, localBrokerId);
            } else {
                this.rollback(groupNew, groupOld, replicasNew, replicasOld, localBrokerId);
            }
            return BooleanAck.build();
        }
        catch (Exception e) {
            logger.error(String.format("UpdatePartitionGroupHandler request command[%s] error", command.getPayload()), (Throwable)e);
            return BooleanAck.build((JoyQueueCode)JoyQueueCode.CN_UNKNOWN_ERROR, (Object[])new Object[]{e.getMessage()});
        }
    }

    private void commit(PartitionGroup groupNew, PartitionGroup groupOld, Set<Integer> nodeAdd, Set<Integer> nodeRemove, Integer localBrokerId) throws Exception {
        ArrayList<Broker> brokers = new ArrayList<Broker>(groupNew.getReplicas().size());
        groupNew.getReplicas().forEach(replica -> brokers.add(this.clusterManager.getBrokerById((Integer)replica)));
        TopicName topicName = groupNew.getTopic();
        String topic = topicName.getFullName();
        for (Integer brokerId : nodeAdd) {
            if (localBrokerId.equals(brokerId)) {
                logger.info("topic[{}] add partitionGroup[{}]", (Object)topic, (Object)groupNew.getGroup());
                this.storeService.createPartitionGroup(topic, groupNew.getGroup(), Shorts.toArray((Collection)groupNew.getPartitions()));
                this.electionService.onPartitionGroupCreate(groupNew.getElectType(), topicName, groupNew.getGroup(), brokers, groupNew.getLearners(), this.clusterManager.getBrokerId(), groupNew.getLeader());
                continue;
            }
            logger.info("topic[{}] update partitionGroup[{}] add node[{}] ", new Object[]{topic, groupNew.getGroup(), brokerId});
            this.electionService.onNodeAdd(topicName, groupNew.getGroup(), groupNew.getElectType(), brokers, groupNew.getLearners(), this.clusterManager.getBrokerById(brokerId), localBrokerId, groupNew.getLeader());
            this.storeService.rePartition(topic, groupNew.getGroup(), groupNew.getPartitions().toArray(new Short[groupNew.getPartitions().size()]));
        }
        if (groupOld.getPartitions().size() != groupNew.getPartitions().size()) {
            this.storeService.rePartition(topic, groupNew.getGroup(), groupNew.getPartitions().toArray(new Short[groupNew.getPartitions().size()]));
        }
        for (Integer brokerId : nodeRemove) {
            if (localBrokerId.equals(brokerId)) {
                logger.info("topic[{}] remove partitionGroup[{}]", (Object)topic, (Object)groupNew.getGroup());
                this.storeService.removePartitionGroup(topic, groupNew.getGroup());
                this.electionService.onPartitionGroupRemove(topicName, groupNew.getGroup());
                continue;
            }
            logger.info("topic[{}] update partitionGroup[{}] remove node[{}] ", new Object[]{topic, groupNew.getGroup(), brokerId});
            this.electionService.onNodeRemove(topicName, groupNew.getGroup(), brokerId, localBrokerId);
            this.storeService.rePartition(topic, groupNew.getGroup(), groupNew.getPartitions().toArray(new Short[groupNew.getPartitions().size()]));
        }
    }

    private void rollback(PartitionGroup groupNew, PartitionGroup groupOld, Set<Integer> nodeAdd, Set<Integer> nodeRemove, Integer localBrokerId) throws Exception {
        TopicName topicName = groupNew.getTopic();
        String topic = topicName.getFullName();
        for (Integer brokerId : nodeAdd) {
            if (localBrokerId.equals(brokerId)) {
                logger.info("topic[{}] remove partitionGroup[{}]", (Object)groupNew.getTerm(), (Object)groupNew.getGroup());
                this.storeService.removePartitionGroup(topic, groupNew.getGroup());
                this.electionService.onPartitionGroupRemove(topicName, groupNew.getGroup());
                continue;
            }
            logger.info("topic[{}] update partitionGroup[{}] remove node[{}] ", new Object[]{groupNew.getTerm(), groupNew.getGroup(), brokerId});
            this.electionService.onNodeRemove(topicName, groupNew.getGroup(), brokerId, localBrokerId);
            this.storeService.rePartition(groupOld.getTopic().getFullName(), groupOld.getGroup(), groupOld.getPartitions().toArray(new Short[groupOld.getPartitions().size()]));
        }
        ArrayList<Broker> brokers = new ArrayList<Broker>(groupOld.getReplicas().size());
        groupNew.getReplicas().forEach(replica -> brokers.add(this.clusterManager.getBrokerById((Integer)replica)));
        for (Integer brokerId : nodeRemove) {
            if (localBrokerId.equals(brokerId)) {
                logger.info("topic[{}] add partitionGroup[{}]", (Object)groupNew.getTerm(), (Object)groupNew.getGroup());
                this.storeService.createPartitionGroup(topic, groupNew.getGroup(), Shorts.toArray((Collection)groupNew.getPartitions()));
                this.electionService.onPartitionGroupCreate(groupNew.getElectType(), topicName, groupNew.getGroup(), brokers, groupNew.getLearners(), this.clusterManager.getBrokerId(), groupNew.getLeader());
                continue;
            }
            logger.info("topic[{}] update partitionGroup[{}] add node[{}] ", new Object[]{groupNew.getTerm(), groupNew.getGroup(), brokerId});
            this.electionService.onNodeAdd(topicName, groupNew.getGroup(), groupNew.getElectType(), brokers, groupNew.getLearners(), this.clusterManager.getBrokerById(brokerId), localBrokerId, groupNew.getLeader());
            this.storeService.rePartition(groupOld.getTopic().getFullName(), groupOld.getGroup(), groupOld.getPartitions().toArray(new Short[groupOld.getPartitions().size()]));
        }
        if (groupOld.getPartitions().size() != groupNew.getPartitions().size()) {
            this.storeService.rePartition(topic, groupOld.getGroup(), groupOld.getPartitions().toArray(new Short[groupOld.getPartitions().size()]));
        }
    }
}

