/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.index.handler;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.index.command.ConsumeIndexQueryRequest;
import org.joyqueue.broker.index.command.ConsumeIndexQueryResponse;
import org.joyqueue.broker.index.model.IndexMetadataAndError;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.exception.TransportException;

public class ConsumeIndexQueryHandler
implements CommandHandler,
Type {
    private BrokerContext brokerContext;
    private Consume consume;

    public ConsumeIndexQueryHandler(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
        this.consume = brokerContext.getConsume();
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        ConsumeIndexQueryRequest request = (ConsumeIndexQueryRequest)((Object)command.getPayload());
        if (request == null) {
            return null;
        }
        Map<String, List<Integer>> indexTopicPartitions = request.getTopicPartitions();
        HashedMap topicPartitionIndex = new HashedMap();
        String app = request.getApp();
        for (String topic : indexTopicPartitions.keySet()) {
            List<Integer> partitions = indexTopicPartitions.get(topic);
            HashedMap partitionIndexes = new HashedMap();
            for (int partition : partitions) {
                long index = this.getConsumerIndex(topic, (short)partition, app);
                IndexMetadataAndError indexMetadataAndError = new IndexMetadataAndError(index, "", (short)JoyQueueCode.SUCCESS.getCode());
                partitionIndexes.put(partition, indexMetadataAndError);
            }
            topicPartitionIndex.put(topic, partitionIndexes);
        }
        ConsumeIndexQueryResponse response = new ConsumeIndexQueryResponse((Map<String, Map<Integer, IndexMetadataAndError>>)topicPartitionIndex);
        JoyQueueHeader header = new JoyQueueHeader(Direction.RESPONSE, QosLevel.ONE_WAY, -47);
        return new Command((Header)header, (Object)response);
    }

    private long getConsumerIndex(String topic, short partition, String app) {
        long ackStartIndex;
        Consumer consumer = new Consumer(topic, app);
        long ackCurIndex = this.consume.getAckIndex(consumer, partition);
        return ackCurIndex == (ackStartIndex = this.consume.getStartIndex(consumer, partition)) ? -1L : ackCurIndex;
    }

    public int type() {
        return 47;
    }
}

