/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.index.handler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.map.HashedMap;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.index.command.ConsumeIndexStoreRequest;
import org.joyqueue.broker.index.command.ConsumeIndexStoreResponse;
import org.joyqueue.broker.index.model.IndexAndMetadata;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeIndexStoreHandler
implements CommandHandler,
Type {
    private final Logger logger = LoggerFactory.getLogger(ConsumeIndexStoreHandler.class);
    private BrokerContext brokerContext;
    private Consume consume;
    private final Cache<String, Long> commitIndexCache = CacheBuilder.newBuilder().expireAfterAccess(60000L, TimeUnit.MILLISECONDS).build();

    public ConsumeIndexStoreHandler(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
        this.consume = brokerContext.getConsume();
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        ConsumeIndexStoreRequest request = (ConsumeIndexStoreRequest)((Object)command.getPayload());
        if (request == null) {
            return null;
        }
        Map<String, Map<Integer, IndexAndMetadata>> indexMetadata = request.getIndexMetadata();
        this.logger.debug("ConsumeIndexStoreRequest info:[{}]", (Object)indexMetadata.toString());
        HashedMap indexStoreStatus = new HashedMap();
        String app = request.getApp();
        for (String topic : indexMetadata.keySet()) {
            Map<Integer, IndexAndMetadata> partitionIndexes = indexMetadata.get(topic);
            HashedMap partitionIndexStoreStatus = new HashedMap();
            for (int partition : partitionIndexes.keySet()) {
                int retCode = JoyQueueCode.SUCCESS.getCode();
                IndexAndMetadata indexAndMetadata = partitionIndexes.get(partition);
                try {
                    this.setConsumeIndex(topic, (short)partition, app, indexAndMetadata.getIndex(), indexAndMetadata.getIndexCommitTime());
                }
                catch (JoyQueueException je) {
                    retCode = je.getCode();
                }
                partitionIndexStoreStatus.put(partition, (short)retCode);
            }
            indexStoreStatus.put(topic, partitionIndexStoreStatus);
        }
        JoyQueueHeader header = new JoyQueueHeader(Direction.RESPONSE, QosLevel.ONE_WAY, -48);
        ConsumeIndexStoreResponse offsetStoreResponse = new ConsumeIndexStoreResponse((Map<String, Map<Integer, Short>>)indexStoreStatus);
        return new Command((Header)header, (Object)offsetStoreResponse);
    }

    private void setConsumeIndex(String topic, short partition, String app, long offset, long commitTime) throws JoyQueueException {
        Consumer consumer = new Consumer(topic, app);
        long lastCommitTime = this.getLastCommitTime(topic, partition, app);
        if (lastCommitTime > commitTime) {
            return;
        }
        this.consume.setAckIndex(consumer, partition, offset);
        this.consume.setStartAckIndex(consumer, partition, -1L);
        this.putLastCommitIndex(topic, partition, app, commitTime);
    }

    protected long getLastCommitTime(String topic, short partition, String app) {
        try {
            return (Long)this.commitIndexCache.get((Object)this.generateIndexKey(topic, partition, app), (Callable)new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    return 0L;
                }
            });
        }
        catch (ExecutionException e) {
            return 0L;
        }
    }

    protected void putLastCommitIndex(String topic, short partition, String app, long commitTime) {
        this.commitIndexCache.put((Object)this.generateIndexKey(topic, partition, app), (Object)commitTime);
    }

    protected String generateIndexKey(String topic, short partition, String app) {
        return String.format("%s_%s_%s", topic, partition, app);
    }

    public int type() {
        return 48;
    }
}

