/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.index.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.joyqueue.broker.index.command.ConsumeIndexQueryResponse;
import org.joyqueue.broker.index.model.IndexMetadataAndError;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadDecoder;
import org.joyqueue.network.transport.command.Type;

public class IndexQueryResponseDecoder
implements PayloadDecoder<JoyQueueHeader>,
Type {
    public Object decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        HashedMap topicPartitionIndex = new HashedMap();
        int topics = buffer.readInt();
        for (int i = 0; i < topics; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitions = buffer.readInt();
            HashedMap partitionIndexs = new HashedMap();
            for (int j = 0; j < partitions; ++j) {
                int partition = buffer.readInt();
                long index = buffer.readLong();
                String metadata = Serializer.readString((ByteBuf)buffer, (int)2);
                short error = buffer.readShort();
                partitionIndexs.put(partition, new IndexMetadataAndError(index, metadata, error));
            }
            topicPartitionIndex.put(topic, partitionIndexs);
        }
        return new ConsumeIndexQueryResponse((Map<String, Map<Integer, IndexMetadataAndError>>)topicPartitionIndex);
    }

    public int type() {
        return -47;
    }
}

