/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.index.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.joyqueue.broker.index.command.ConsumeIndexQueryResponse;
import org.joyqueue.broker.index.model.IndexMetadataAndError;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.PayloadEncoder;
import org.joyqueue.network.transport.command.Type;

public class IndexQueryResponseEncoder
implements PayloadEncoder<ConsumeIndexQueryResponse>,
Type {
    public void encode(ConsumeIndexQueryResponse response, ByteBuf buffer) throws Exception {
        Map<String, Map<Integer, IndexMetadataAndError>> topicPartitionIndex = response.getTopicPartitionIndex();
        buffer.writeInt(topicPartitionIndex.size());
        for (String topic : topicPartitionIndex.keySet()) {
            Serializer.write((String)topic, (ByteBuf)buffer, (int)2);
            Map<Integer, IndexMetadataAndError> partitionIndexs = topicPartitionIndex.get(topic);
            buffer.writeInt(partitionIndexs.size());
            for (int partition : partitionIndexs.keySet()) {
                buffer.writeInt(partition);
                IndexMetadataAndError index = partitionIndexs.get(partition);
                buffer.writeLong(index.getIndex());
                Serializer.write((String)index.getMetadata(), (ByteBuf)buffer, (int)2);
                buffer.writeShort((int)index.getError());
            }
        }
    }

    public int type() {
        return -47;
    }
}

