/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.index.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.joyqueue.broker.index.command.ConsumeIndexStoreRequest;
import org.joyqueue.broker.index.model.IndexAndMetadata;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.PayloadEncoder;
import org.joyqueue.network.transport.command.Type;

public class IndexStoreRequestEncoder
implements PayloadEncoder<ConsumeIndexStoreRequest>,
Type {
    public void encode(ConsumeIndexStoreRequest request, ByteBuf buffer) throws Exception {
        Map<String, Map<Integer, IndexAndMetadata>> indexMetadata = request.getIndexMetadata();
        Serializer.write((String)request.getApp(), (ByteBuf)buffer, (int)2);
        buffer.writeInt(indexMetadata.size());
        for (String topic : indexMetadata.keySet()) {
            Serializer.write((String)topic, (ByteBuf)buffer, (int)2);
            Map<Integer, IndexAndMetadata> partitionMetadata = indexMetadata.get(topic);
            buffer.writeInt(partitionMetadata.size());
            for (int partition : partitionMetadata.keySet()) {
                buffer.writeInt(partition);
                IndexAndMetadata indexAndMetadata = partitionMetadata.get(partition);
                buffer.writeLong(indexAndMetadata.getIndex());
                Serializer.write((String)indexAndMetadata.getMetadata(), (ByteBuf)buffer, (int)2);
                buffer.writeLong(indexAndMetadata.getIndexCacheRetainTime());
                buffer.writeLong(indexAndMetadata.getIndexCommitTime());
            }
        }
    }

    public int type() {
        return 48;
    }
}

