/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.limit.filter;

import org.joyqueue.broker.network.protocol.ProtocolCommandHandlerFilter;
import org.joyqueue.broker.network.traffic.RequestTrafficPayload;
import org.joyqueue.broker.network.traffic.ResponseTrafficPayload;
import org.joyqueue.broker.network.traffic.Traffic;
import org.joyqueue.broker.network.traffic.TrafficPayload;
import org.joyqueue.broker.network.traffic.TrafficType;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.handler.filter.CommandHandlerInvocation;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLimitFilter
implements ProtocolCommandHandlerFilter {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractLimitFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command invoke(CommandHandlerInvocation invocation) throws TransportException {
        Command request = invocation.getRequest();
        boolean isRequired = false;
        RequestTrafficPayload requestTrafficPayload = this.getRequestTrafficPayload(request);
        if (requestTrafficPayload != null) {
            if (this.limitIfNeeded(requestTrafficPayload)) {
                requestTrafficPayload.getTraffic().limited(true);
            } else if (this.requireIfAcquired(requestTrafficPayload)) {
                isRequired = true;
            } else {
                requestTrafficPayload.getTraffic().limited(true);
            }
        } else {
            isRequired = true;
        }
        try {
            Command response = invocation.invoke();
            if (response == null) {
                Command command = response;
                return command;
            }
            ResponseTrafficPayload responseTrafficPayload = this.getResponseTrafficPayload(request, response);
            if (responseTrafficPayload == null) {
                Command command = response;
                return command;
            }
            if (!this.limitIfNeeded(responseTrafficPayload)) {
                if (requestTrafficPayload != null && requestTrafficPayload.getTraffic().isLimited()) {
                    Command command = this.doLimit(invocation.getTransport(), request, response, isRequired);
                    return command;
                }
                Command command = response;
                return command;
            }
            Command command = this.doLimit(invocation.getTransport(), request, response, isRequired);
            return command;
        }
        finally {
            if (isRequired && requestTrafficPayload != null) {
                this.releaseRequire(requestTrafficPayload);
            }
        }
    }

    protected RequestTrafficPayload getRequestTrafficPayload(Command request) {
        if (request != null && request.getPayload() instanceof RequestTrafficPayload) {
            return (RequestTrafficPayload)request.getPayload();
        }
        return null;
    }

    protected ResponseTrafficPayload getResponseTrafficPayload(Command request, Command response) {
        if (response != null && response.getPayload() instanceof ResponseTrafficPayload) {
            return (ResponseTrafficPayload)response.getPayload();
        }
        if (request != null && request.getPayload() instanceof ResponseTrafficPayload) {
            return (ResponseTrafficPayload)request.getPayload();
        }
        return null;
    }

    protected boolean releaseRequire(TrafficPayload trafficPayload) {
        Traffic traffic = trafficPayload.getTraffic();
        if (!(trafficPayload instanceof TrafficType) || traffic == null) {
            return false;
        }
        return this.releaseRequire((TrafficType)((Object)trafficPayload), traffic);
    }

    protected boolean requireIfAcquired(TrafficPayload trafficPayload) {
        Traffic traffic = trafficPayload.getTraffic();
        if (!(trafficPayload instanceof TrafficType) || traffic == null) {
            return false;
        }
        return this.requireIfAcquired((TrafficType)((Object)trafficPayload), traffic);
    }

    protected boolean limitIfNeeded(TrafficPayload trafficPayload) {
        Traffic traffic = trafficPayload.getTraffic();
        if (!(trafficPayload instanceof TrafficType) || traffic == null) {
            return false;
        }
        return this.limitIfNeeded((TrafficType)((Object)trafficPayload), traffic);
    }

    protected boolean limitIfNeeded(TrafficType trafficType, Traffic traffic) {
        String type = trafficType.getTrafficType();
        String app = traffic.getApp();
        for (String topic : traffic.getTopics()) {
            if (!this.limitIfNeeded(topic, app, type, traffic)) continue;
            return true;
        }
        return false;
    }

    protected boolean requireIfAcquired(TrafficType trafficType, Traffic traffic) {
        String type = trafficType.getTrafficType();
        String app = traffic.getApp();
        for (String topic : traffic.getTopics()) {
            if (!this.requireIfAcquired(topic, app, type)) continue;
            return true;
        }
        return false;
    }

    protected boolean releaseRequire(TrafficType trafficType, Traffic traffic) {
        String type = trafficType.getTrafficType();
        String app = traffic.getApp();
        for (String topic : traffic.getTopics()) {
            if (!this.releaseRequire(topic, app, type)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean requireIfAcquired(String var1, String var2, String var3);

    protected abstract boolean releaseRequire(String var1, String var2, String var3);

    protected abstract boolean limitIfNeeded(String var1, String var2, String var3, Traffic var4);

    protected abstract Command doLimit(Transport var1, Command var2, Command var3, boolean var4);
}

