/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.limit.support;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.limit.RateLimitManager;
import org.joyqueue.broker.limit.RateLimiter;
import org.joyqueue.broker.limit.config.LimiterConfig;
import org.joyqueue.broker.limit.support.DefaultRateLimiter;
import org.joyqueue.broker.limit.support.NoneRateLimiter;

public abstract class AbstractRateLimiterManager
implements RateLimitManager {
    private static final RateLimiter NONE_RATE_LIMITER = new NoneRateLimiter();
    private ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, RateLimiter>>> rateLimiterMapper = Maps.newConcurrentMap();

    @Override
    public RateLimiter getRateLimiter(String topic, String app, String type) {
        ConcurrentMap<String, RateLimiter> rateLimiterMapper = this.getOrCreateTypeRateLimiterMapper(topic, app);
        RateLimiter rateLimiter = (RateLimiter)rateLimiterMapper.get(type);
        if (rateLimiter != null) {
            return rateLimiter;
        }
        rateLimiter = this.newRateLimiter(topic, app, type);
        RateLimiter oldRateLimiter = rateLimiterMapper.putIfAbsent(type, rateLimiter);
        if (oldRateLimiter != null) {
            rateLimiter = oldRateLimiter;
        }
        return rateLimiter;
    }

    protected RateLimiter newRateLimiter(String topic, String app, String type) {
        LimiterConfig limiterConfig = this.getLimiterConfig(topic, app, type);
        if (limiterConfig == null) {
            return NONE_RATE_LIMITER;
        }
        return this.newRateLimiter(topic, app, type, limiterConfig);
    }

    protected RateLimiter newRateLimiter(String topic, String app, String type, LimiterConfig limiterConfig) {
        return new DefaultRateLimiter(limiterConfig.getTps(), limiterConfig.getTraffic());
    }

    protected ConcurrentMap<String, RateLimiter> getOrCreateTypeRateLimiterMapper(String topic, String app) {
        ConcurrentMap<String, RateLimiter> oldTypeMapper;
        ConcurrentMap<String, RateLimiter> typeMapper;
        ConcurrentMap<String, ConcurrentMap<String, RateLimiter>> oldAppMapper;
        ConcurrentMap<String, ConcurrentMap<String, RateLimiter>> appMapper = (ConcurrentMap<String, ConcurrentMap<String, RateLimiter>>)this.rateLimiterMapper.get(topic);
        if (appMapper == null && (oldAppMapper = this.rateLimiterMapper.putIfAbsent(topic, appMapper = Maps.newConcurrentMap())) != null) {
            appMapper = oldAppMapper;
        }
        if ((typeMapper = (ConcurrentMap<String, RateLimiter>)appMapper.get(app)) == null && (oldTypeMapper = appMapper.putIfAbsent(app, typeMapper = Maps.newConcurrentMap())) != null) {
            typeMapper = oldTypeMapper;
        }
        return typeMapper;
    }

    protected void removeAppRateLimiter(String topic, String app) {
        ConcurrentMap appMapper = (ConcurrentMap)this.rateLimiterMapper.get(topic);
        if (appMapper == null) {
            return;
        }
        appMapper.remove(app);
    }

    protected void removeTopicRateLimiter(String topic) {
        this.rateLimiterMapper.remove(topic);
    }

    protected abstract LimiterConfig getLimiterConfig(String var1, String var2, String var3);
}

