/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.limit.support;

import java.util.concurrent.Semaphore;
import org.joyqueue.broker.limit.RateLimiter;

public class DefaultRateLimiter
implements RateLimiter {
    private int tps;
    private int traffic;
    private com.google.common.util.concurrent.RateLimiter tpsRateLimiter;
    private com.google.common.util.concurrent.RateLimiter trafficRateLimiter;
    private Semaphore semaphore = new Semaphore(1);

    public DefaultRateLimiter(int tps) {
        this.tps = tps;
        this.tpsRateLimiter = com.google.common.util.concurrent.RateLimiter.create((double)tps);
    }

    public DefaultRateLimiter(int tps, int traffic) {
        this.tps = tps;
        this.traffic = traffic;
        this.tpsRateLimiter = com.google.common.util.concurrent.RateLimiter.create((double)tps);
        this.trafficRateLimiter = com.google.common.util.concurrent.RateLimiter.create((double)traffic);
    }

    @Override
    public boolean tryAcquireTps() {
        return this.tryAcquireTps(1);
    }

    @Override
    public boolean tryAcquireTps(int tps) {
        if (tps <= 0) {
            return true;
        }
        return this.tpsRateLimiter.tryAcquire(Math.min(tps, this.tps));
    }

    @Override
    public boolean tryAcquireTraffic(int traffic) {
        if (traffic <= 0) {
            return true;
        }
        return this.trafficRateLimiter.tryAcquire(Math.min(traffic, this.traffic));
    }

    @Override
    public boolean tryAcquireRequire() {
        return this.semaphore.tryAcquire();
    }

    @Override
    public boolean releaseRequire() {
        this.semaphore.release();
        return true;
    }
}

