/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage;

import org.joyqueue.broker.archive.ArchiveManager;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.cluster.ClusterNameService;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.MessageConvertSupport;
import org.joyqueue.broker.coordinator.CoordinatorService;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.manage.BrokerManageServiceManager;
import org.joyqueue.broker.manage.config.BrokerManageConfig;
import org.joyqueue.broker.manage.exporter.BrokerManageExporter;
import org.joyqueue.broker.monitor.BrokerMonitorService;
import org.joyqueue.nsr.NameService;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.store.StoreManagementService;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.service.Service;

public class BrokerManageService
extends Service {
    private BrokerManageConfig config;
    private BrokerManageServiceManager brokerManageServiceManager;
    private BrokerManageExporter brokerManageExporter;
    private StoreService storeService;
    private MessageRetry retryManager;
    private CoordinatorService coordinatorService;
    private ArchiveManager archiveManager;
    private MessageConvertSupport messageConvertSupport;

    public BrokerManageService(BrokerManageConfig config, BrokerMonitorService brokerMonitorService, ClusterManager clusterManager, ClusterNameService clusterNameService, StoreManagementService storeManagementService, StoreService storeService, Consume consume, MessageRetry retryManager, CoordinatorService coordinatorService, ArchiveManager archiveManager, NameService nameService, ElectionService electionManager, MessageConvertSupport messageConvertSupport) {
        this.config = config;
        this.storeService = storeService;
        this.retryManager = retryManager;
        this.coordinatorService = coordinatorService;
        this.brokerManageServiceManager = new BrokerManageServiceManager(brokerMonitorService.getBrokerMonitor(), clusterManager, clusterNameService, storeManagementService, storeService, consume, retryManager, coordinatorService, archiveManager, nameService, electionManager, messageConvertSupport);
        this.brokerManageExporter = new BrokerManageExporter(config, this.brokerManageServiceManager);
    }

    public void registerService(String key, Object service) {
        this.brokerManageExporter.registerService(key, service);
    }

    protected void doStart() throws Exception {
        this.brokerManageServiceManager.start();
        this.brokerManageExporter.start();
    }

    protected void doStop() {
        if (this.brokerManageExporter != null) {
            this.brokerManageExporter.stop();
        }
        if (this.brokerManageServiceManager != null) {
            this.brokerManageServiceManager.stop();
        }
    }

    public BrokerManageConfig getConfig() {
        return this.config;
    }

    public BrokerManageServiceManager getBrokerManageServiceManager() {
        return this.brokerManageServiceManager;
    }
}

