/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage;

import java.io.InputStream;
import java.util.Properties;
import org.joyqueue.broker.archive.ArchiveManager;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.cluster.ClusterNameService;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.MessageConvertSupport;
import org.joyqueue.broker.coordinator.CoordinatorService;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.manage.service.BrokerManageService;
import org.joyqueue.broker.manage.service.support.DefaultBrokerManageService;
import org.joyqueue.broker.manage.service.support.DefaultConnectionManageService;
import org.joyqueue.broker.manage.service.support.DefaultConsumerManageService;
import org.joyqueue.broker.manage.service.support.DefaultCoordinatorManageService;
import org.joyqueue.broker.manage.service.support.DefaultElectionManageService;
import org.joyqueue.broker.manage.service.support.DefaultMessageManageService;
import org.joyqueue.broker.manage.service.support.DefaultStoreManageService;
import org.joyqueue.broker.monitor.BrokerMonitor;
import org.joyqueue.broker.monitor.service.BrokerMonitorService;
import org.joyqueue.broker.monitor.service.support.DefaultArchiveMonitorService;
import org.joyqueue.broker.monitor.service.support.DefaultBrokerMonitorInternalService;
import org.joyqueue.broker.monitor.service.support.DefaultBrokerMonitorService;
import org.joyqueue.broker.monitor.service.support.DefaultConnectionMonitorService;
import org.joyqueue.broker.monitor.service.support.DefaultConsumerMonitorService;
import org.joyqueue.broker.monitor.service.support.DefaultCoordinatorMonitorService;
import org.joyqueue.broker.monitor.service.support.DefaultMetadataMonitorService;
import org.joyqueue.broker.monitor.service.support.DefaultPartitionMonitorService;
import org.joyqueue.broker.monitor.service.support.DefaultProducerMonitorService;
import org.joyqueue.broker.monitor.service.support.DefaultTopicMonitorService;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.monitor.BrokerStartupInfo;
import org.joyqueue.nsr.NameService;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.store.StoreManagementService;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;

public class BrokerManageServiceManager
extends Service {
    private BrokerMonitor brokerMonitor;
    private ClusterManager clusterManager;
    private ClusterNameService clusterNameService;
    private StoreManagementService storeManagementService;
    private StoreService storeService;
    private Consume consume;
    private BrokerMonitorService brokerMonitorService;
    private BrokerManageService brokerManageService;
    private MessageRetry retryManager;
    private CoordinatorService coordinatorService;
    private ArchiveManager archiveManager;
    private NameService nameService;
    private ElectionService electionManager;
    private MessageConvertSupport messageConvertSupport;

    public BrokerManageServiceManager(BrokerMonitor brokerMonitor, ClusterManager clusterManager, ClusterNameService clusterNameService, StoreManagementService storeManagementService, StoreService storeService, Consume consume, MessageRetry messageRetry, CoordinatorService coordinatorService, ArchiveManager archiveManager, NameService nameService, ElectionService electionManager, MessageConvertSupport messageConvertSupport) {
        this.brokerMonitor = brokerMonitor;
        this.clusterManager = clusterManager;
        this.clusterNameService = clusterNameService;
        this.storeManagementService = storeManagementService;
        this.storeService = storeService;
        this.consume = consume;
        this.retryManager = messageRetry;
        this.coordinatorService = coordinatorService;
        this.archiveManager = archiveManager;
        this.nameService = nameService;
        this.electionManager = electionManager;
        this.messageConvertSupport = messageConvertSupport;
    }

    protected void validate() throws Exception {
        this.brokerMonitorService = this.newBrokerMonitorService();
        this.brokerManageService = this.newBrokerManageService();
    }

    protected BrokerMonitorService newBrokerMonitorService() {
        BrokerStat brokerStat = this.brokerMonitor.getBrokerStat();
        BrokerStartupInfo brokerStartupInfo = this.newBrokerStartInfo();
        DefaultBrokerMonitorInternalService brokerMonitorInternalService = new DefaultBrokerMonitorInternalService(brokerStat, this.consume, this.storeManagementService, this.nameService, this.storeService, this.electionManager, this.clusterManager, brokerStartupInfo, this.archiveManager);
        DefaultConnectionMonitorService connectionMonitorService = new DefaultConnectionMonitorService(brokerStat);
        DefaultConsumerMonitorService consumerMonitorService = new DefaultConsumerMonitorService(brokerStat, this.consume, this.storeManagementService, this.retryManager, this.clusterManager);
        DefaultProducerMonitorService producerMonitorService = new DefaultProducerMonitorService(brokerStat, this.storeManagementService, this.clusterManager);
        DefaultTopicMonitorService topicMonitorService = new DefaultTopicMonitorService(brokerStat, this.storeManagementService);
        DefaultPartitionMonitorService partitionMonitorService = new DefaultPartitionMonitorService(brokerStat, this.storeManagementService, this.electionManager);
        DefaultCoordinatorMonitorService coordinatorMonitorService = new DefaultCoordinatorMonitorService(this.coordinatorService);
        DefaultArchiveMonitorService archiveMonitorService = new DefaultArchiveMonitorService(this.archiveManager);
        DefaultMetadataMonitorService metadataMonitorService = new DefaultMetadataMonitorService(this.clusterManager, this.clusterNameService);
        return new DefaultBrokerMonitorService(brokerMonitorInternalService, connectionMonitorService, consumerMonitorService, producerMonitorService, topicMonitorService, partitionMonitorService, coordinatorMonitorService, archiveMonitorService, metadataMonitorService);
    }

    protected BrokerManageService newBrokerManageService() {
        DefaultConnectionManageService connectionManageService = new DefaultConnectionManageService(this.brokerMonitor.getSessionManager());
        DefaultMessageManageService messageManageService = new DefaultMessageManageService(this.consume, this.storeManagementService, this.messageConvertSupport);
        DefaultStoreManageService storeManageService = new DefaultStoreManageService(this.storeManagementService);
        DefaultConsumerManageService consumerManageService = new DefaultConsumerManageService(this.consume, this.storeManagementService, this.storeService, this.clusterManager, this.brokerMonitor);
        DefaultCoordinatorManageService coordinatorManageService = new DefaultCoordinatorManageService(this.coordinatorService);
        DefaultElectionManageService electionManageService = new DefaultElectionManageService(this.electionManager);
        return new DefaultBrokerManageService(connectionManageService, messageManageService, storeManageService, consumerManageService, coordinatorManageService, electionManageService);
    }

    protected BrokerStartupInfo newBrokerStartInfo() {
        Properties properties2;
        Throwable throwable;
        InputStream propFile2;
        BrokerStartupInfo brokerStartupInfo = new BrokerStartupInfo();
        brokerStartupInfo.setStartupTime(SystemClock.now());
        String revision = null;
        String commitDate = null;
        try {
            propFile2 = BrokerManageServiceManager.class.getClassLoader().getResourceAsStream(".version.properties");
            throwable = null;
            try {
                if (propFile2 != null) {
                    properties2 = new Properties();
                    properties2.load(propFile2);
                    String propRevision = properties2.getProperty("git.commit.id.abbrev");
                    String propCommitDate = properties2.getProperty("git.commit.time");
                    revision = propRevision != null ? propRevision : "UNKNOWN";
                    commitDate = propCommitDate != null ? propCommitDate : "UNKNOWN";
                }
            }
            catch (Throwable properties2) {
                throwable = properties2;
                throw properties2;
            }
            finally {
                if (propFile2 != null) {
                    if (throwable != null) {
                        try {
                            propFile2.close();
                        }
                        catch (Throwable properties2) {
                            throwable.addSuppressed(properties2);
                        }
                    } else {
                        propFile2.close();
                    }
                }
            }
        }
        catch (Throwable propFile2) {
            // empty catch block
        }
        try {
            propFile2 = BrokerManageServiceManager.class.getClassLoader().getResourceAsStream("joyqueue/version.properties");
            throwable = null;
            try {
                if (propFile2 != null) {
                    properties2 = new Properties();
                    properties2.load(propFile2);
                    brokerStartupInfo.setVersion(properties2.getProperty("version"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (propFile2 != null) {
                    if (throwable != null) {
                        try {
                            propFile2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        propFile2.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            // empty catch block
        }
        brokerStartupInfo.setCommitDate(commitDate);
        brokerStartupInfo.setRevision(revision);
        return brokerStartupInfo;
    }

    public BrokerManageService getBrokerManageService() {
        return this.brokerManageService;
    }

    public BrokerMonitorService getBrokerMonitorService() {
        return this.brokerMonitorService;
    }
}

