/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage.exporter;

import com.google.common.collect.Maps;
import com.jd.laf.web.vertx.Environment;
import io.vertx.core.http.HttpServerOptions;
import java.util.Map;
import org.joyqueue.broker.manage.config.BrokerManageConfig;
import org.joyqueue.broker.manage.exporter.vertx.RoutingVerticle;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerManageExportServer
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(BrokerManageExportServer.class);
    private BrokerManageConfig config;
    private RoutingVerticle routingVerticle;
    private Map<String, Object> serviceMap = Maps.newHashMap();

    public BrokerManageExportServer(BrokerManageConfig config) {
        this.config = config;
    }

    public void registerServices(Map<String, Object> serviceMap) {
        this.serviceMap.putAll(serviceMap);
    }

    public void registerService(String key, Object service) {
        this.serviceMap.put(key, service);
    }

    protected RoutingVerticle initRoutingVerticle(BrokerManageConfig config) {
        HttpServerOptions httpServerOptions = new HttpServerOptions();
        httpServerOptions.setPort(config.getExportPort());
        return new RoutingVerticle((Environment)new Environment.MapEnvironment(), httpServerOptions);
    }

    protected void validate() throws Exception {
        this.routingVerticle = this.initRoutingVerticle(this.config);
    }

    protected void doStart() throws Exception {
        try {
            this.routingVerticle.registerServices(this.serviceMap);
            this.routingVerticle.start();
            logger.info("broker manage server is started, port: {}", (Object)this.config.getExportPort());
        }
        catch (Exception e) {
            logger.error("broker manage server start exception", (Throwable)e);
            throw e;
        }
    }

    protected void doStop() {
        try {
            this.routingVerticle.stop();
        }
        catch (Exception e) {
            logger.error("broker manage server stop exception", (Throwable)e);
        }
    }
}

