/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage.exporter.vertx;

import com.jd.laf.extension.ExtensionPoint;
import com.jd.laf.extension.ExtensionPointLazy;
import com.jd.laf.extension.SpiLoader;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.manage.exporter.vertx.HandlerInvoker;
import org.joyqueue.broker.monitor.converter.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertInvoker
extends HandlerInvoker {
    ExtensionPoint<Converter, String> converters = new ExtensionPointLazy(Converter.class, SpiLoader.INSTANCE, null, null);
    private static final String CONVERTER_PARAM = "_target";
    private static final String CONVERTER_HEADER = "User-Agent";
    protected static final Logger logger = LoggerFactory.getLogger(ConvertInvoker.class);

    public ConvertInvoker(Object service, String methodName, Map<String, Class<?>> params) {
        super(service, methodName, params);
    }

    @Override
    public Object invoke(RoutingContext context) throws Exception {
        String target = this.getTarget(context);
        Object result = super.invoke(context);
        if (StringUtils.isBlank((CharSequence)target) || result == null) {
            return result;
        }
        Converter converter = (Converter)this.converters.get((Object)target);
        if (converter == null) {
            return result;
        }
        return converter.convert(result);
    }

    protected String getTarget(RoutingContext context) {
        String targetParam = context.request().getParam(CONVERTER_PARAM);
        if (StringUtils.isNotBlank((CharSequence)targetParam)) {
            return targetParam;
        }
        return context.request().getHeader(CONVERTER_HEADER);
    }
}

