/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage.exporter.vertx;

import com.alibaba.fastjson.JSON;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.beanutils.ConvertUtils;

public class HandlerInvoker {
    private Object service;
    private String methodName;
    private Map<String, Class<?>> params;
    private Method method;

    public HandlerInvoker(Object service, String methodName, Map<String, Class<?>> params) {
        this.service = service;
        this.methodName = methodName;
        this.params = params;
        this.method = this.getMethod(service, methodName);
    }

    protected Method getMethod(Object service, String methodName) {
        for (Method method : service.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new IllegalArgumentException(String.format("method not exist, method: %s.%s", service.getClass().getSimpleName(), methodName));
    }

    public Object invoke(RoutingContext context) throws Exception {
        if (this.params.isEmpty()) {
            return this.method.invoke(this.service, new Object[0]);
        }
        Object[] args = new Object[this.params.size()];
        int index = 0;
        for (Map.Entry<String, Class<?>> entry : this.params.entrySet()) {
            Object value;
            String valueStr = context.request().getParam(entry.getKey());
            args[index] = value = this.convertParam(entry.getKey(), entry.getValue(), valueStr);
            ++index;
        }
        return this.method.invoke(this.service, args);
    }

    protected Object convertParam(String name, Class<?> type, String value) {
        if (type.getName().startsWith("java.lang")) {
            return ConvertUtils.convert((String)value, type);
        }
        return JSON.parseObject((String)value, type);
    }
}

