/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage.exporter.vertx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.joyqueue.broker.manage.exporter.vertx.HandlerInvoker;
import org.joyqueue.monitor.RestResponse;
import org.joyqueue.monitor.StringResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestHandler
implements Handler<RoutingContext> {
    protected static final Logger logger = LoggerFactory.getLogger(RestHandler.class);
    private HandlerInvoker handlerInvoker;

    public RestHandler(HandlerInvoker handlerInvoker) {
        this.handlerInvoker = handlerInvoker;
    }

    public void handle(RoutingContext context) {
        RestResponse response = null;
        try {
            Object result = this.handlerInvoker.invoke(context);
            response = result instanceof RestResponse ? (RestResponse)result : RestResponse.success((Object)result);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            if (t instanceof IllegalArgumentException) {
                logger.debug("request IllegalArgumentException, path: {}, params: {}", new Object[]{context.request().path(), context.request().params(), t});
                response = RestResponse.paramError((String)t.getMessage());
            }
            logger.error("request exception, path: {}, params: {}", new Object[]{context.request().path(), context.request().params(), t});
            response = RestResponse.serverError((String)t.toString());
        }
        HttpServerResponse httpResponse = context.response();
        if (response.getData() instanceof StringResponse) {
            for (Map.Entry entry : ((StringResponse)response.getData()).getHeaders().entrySet()) {
                httpResponse.putHeader((String)entry.getKey(), (String)entry.getValue());
            }
            httpResponse.end(((StringResponse)response.getData()).getBody());
        } else {
            httpResponse.putHeader("Content-Type", "application/json;charset=utf-8");
            httpResponse.end(JSON.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.DisableCircularReferenceDetect}));
        }
    }
}

