/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage.exporter.vertx;

import com.google.common.collect.Maps;
import com.jd.laf.web.vertx.Environment;
import com.jd.laf.web.vertx.RouteProvider;
import com.jd.laf.web.vertx.config.RouteConfig;
import com.jd.laf.web.vertx.config.VertxConfig;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Route;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.manage.exporter.vertx.ConvertInvoker;
import org.joyqueue.broker.manage.exporter.vertx.RestHandler;
import org.joyqueue.toolkit.util.ASMUtils;

public class RoutingVerticle
extends com.jd.laf.web.vertx.RoutingVerticle {
    private static final String SERVICE_SEPARATOR = ".";
    private static final String BASE_ROUTING = "manage/base_routing.xml";
    private static final String ROUTING = "manage/routing.xml";
    private final Map<String, Object> serviceMap = Maps.newHashMap();

    public RoutingVerticle(Environment env, HttpServerOptions httpOptions) {
        super(env, httpOptions, ROUTING);
        Vertx vertx = Vertx.vertx();
        this.init(vertx, vertx.getOrCreateContext());
    }

    public void registerServices(Map<String, Object> serviceMap) {
        this.serviceMap.putAll(serviceMap);
    }

    public void registerService(String key, Object service) {
        this.serviceMap.put(key, service);
    }

    public void start() throws Exception {
        try {
            this.config = VertxConfig.Builder.inherit((VertxConfig)this.buildConfig(this.buildBaseConfig(BASE_ROUTING), this.file));
            this.register(this.vertx, this.env, this.config);
            this.router = this.createRouter(this.env);
            this.addRoutes(this.router, this.config.getRoutes(), this.env);
            if (this.providers != null) {
                for (RouteProvider provider : this.providers) {
                    this.addRoutes(this.router, provider.getRoutes(), this.env);
                }
            }
            this.startHttpServer();
            this.dynamicRoute();
            logger.info((Object)String.format("success starting routing verticle %d at %s", this.id, this.deploymentID()));
        }
        catch (Exception e) {
            logger.error((Object)String.format("failed starting routing verticle %d at %s", this.id, this.deploymentID()), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VertxConfig buildBaseConfig(String file) throws Exception {
        if (file == null || file.isEmpty()) {
            throw new IllegalStateException("file can not be empty.");
        }
        try (BufferedReader reader = null;){
            InputStream inputStream = VertxConfig.class.getClassLoader().getResourceAsStream(file);
            reader = new BufferedReader(new InputStreamReader(inputStream));
            VertxConfig vertxConfig = VertxConfig.Builder.build((Reader)reader);
            return vertxConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VertxConfig buildConfig(VertxConfig baseConfig, String file) throws Exception {
        if (file == null || file.isEmpty()) {
            throw new IllegalStateException("file can not be empty.");
        }
        VertxConfig result = baseConfig;
        Enumeration<URL> resources = VertxConfig.class.getClassLoader().getResources(file);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            BufferedReader reader = null;
            try {
                InputStream inputStream = resource.openStream();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                VertxConfig config = VertxConfig.Builder.build((Reader)reader);
                result.getRoutes().addAll(config.getRoutes());
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        return result;
    }

    protected void buildHandlers(Route route, RouteConfig config, Environment environment) {
        String handler = (String)config.getHandlers().get(0);
        String[] splitsHandler = StringUtils.splitByWholeSeparator((String)handler, (String)SERVICE_SEPARATOR);
        if (splitsHandler.length != 2) {
            throw new IllegalArgumentException("handler error");
        }
        String serviceKey = splitsHandler[0];
        String methodName = splitsHandler[1];
        Object service = this.serviceMap.get(serviceKey);
        if (service == null) {
            throw new IllegalArgumentException(String.format("service %s not exist", serviceKey));
        }
        Map params = ASMUtils.getParams(service.getClass(), (String)methodName);
        ConvertInvoker handlerInvoker = new ConvertInvoker(service, methodName, params);
        route.handler((Handler)new RestHandler(handlerInvoker));
    }
}

