/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage.service.support;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.joyqueue.broker.manage.service.ConnectionManageService;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.session.Producer;

public class DefaultConnectionManageService
implements ConnectionManageService {
    private SessionManager sessionManager;

    public DefaultConnectionManageService(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public int closeProducer(String topic, String app) {
        LinkedList connectionIdList = Lists.newLinkedList();
        for (Producer producer : this.sessionManager.getProducer()) {
            if (!producer.getTopic().equals(topic) || !producer.getApp().equals(app)) continue;
            connectionIdList.add(producer.getConnectionId());
        }
        for (String connectionId : connectionIdList) {
            this.sessionManager.getConnectionById(connectionId).getTransport().stop();
        }
        return connectionIdList.size();
    }

    @Override
    public int closeConsumer(String topic, String app) {
        LinkedList connectionIdList = Lists.newLinkedList();
        for (Consumer consumer : this.sessionManager.getConsumer()) {
            if (!consumer.getTopic().equals(topic) || !consumer.getApp().equals(app)) continue;
            connectionIdList.add(consumer.getConnectionId());
        }
        for (String connectionId : connectionIdList) {
            this.sessionManager.getConnectionById(connectionId).getTransport().stop();
        }
        return connectionIdList.size();
    }
}

