/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage.service.support;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.manage.service.ConsumerManageService;
import org.joyqueue.broker.monitor.ConsumerMonitor;
import org.joyqueue.broker.monitor.stat.PartitionStat;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.monitor.PartitionAckMonitorInfo;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.StoreManagementService;
import org.joyqueue.store.StoreService;

public class DefaultConsumerManageService
implements ConsumerManageService {
    private Consume consume;
    private StoreManagementService storeManagementService;
    private StoreService storeService;
    private ClusterManager clusterManager;
    private ConsumerMonitor consumerMonitor;

    public DefaultConsumerManageService(Consume consume, StoreManagementService storeManagementService, StoreService storeService, ClusterManager clusterManager, ConsumerMonitor consumerMonitor) {
        this.consume = consume;
        this.storeManagementService = storeManagementService;
        this.storeService = storeService;
        this.clusterManager = clusterManager;
        this.consumerMonitor = consumerMonitor;
    }

    @Override
    public boolean setAckIndex(String topic, String app, short partition, long index) throws JoyQueueException {
        org.joyqueue.network.session.Consumer consumer = new org.joyqueue.network.session.Consumer();
        consumer.setTopic(topic);
        consumer.setApp(app);
        this.consume.setAckIndex(consumer, partition, index);
        return true;
    }

    @Override
    public boolean setMaxAckIndex(String topic, String app, short partition) throws JoyQueueException {
        StoreManagementService.PartitionMetric partitionMetric = this.storeManagementService.partitionMetric(topic, partition);
        org.joyqueue.network.session.Consumer consumer = new org.joyqueue.network.session.Consumer();
        consumer.setTopic(topic);
        consumer.setApp(app);
        this.consume.setAckIndex(consumer, partition, partitionMetric.getRightIndex());
        return true;
    }

    @Override
    public long getAckIndex(String topic, String app, short partition) {
        org.joyqueue.network.session.Consumer consumer = new org.joyqueue.network.session.Consumer();
        consumer.setTopic(topic);
        consumer.setApp(app);
        return this.consume.getAckIndex(consumer, partition);
    }

    @Override
    public List<PartitionAckMonitorInfo> getAckIndexes(String topic, String app) {
        ArrayList result = Lists.newArrayList();
        org.joyqueue.network.session.Consumer consumer = new org.joyqueue.network.session.Consumer();
        consumer.setTopic(topic);
        consumer.setApp(app);
        StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(topic);
        for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
            for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                if (!this.clusterManager.isLeader(topic, partitionMetric.getPartition())) continue;
                long index = this.consume.getAckIndex(consumer, partitionMetric.getPartition());
                PartitionStat partitionStat = this.consumerMonitor.getConsumerStat(consumer.getTopic(), consumer.getApp()).getOrCreatePartitionGroupStat(partitionGroupMetric.getPartitionGroup()).getOrCreatePartitionStat(partitionMetric.getPartition());
                long lastAckTime = partitionStat.getLastAckTime();
                long lastPullTime = partitionStat.getLastPullTime();
                result.add(new PartitionAckMonitorInfo(partitionMetric.getPartition(), index, lastPullTime, lastAckTime, partitionMetric.getLeftIndex(), partitionMetric.getRightIndex()));
            }
        }
        return result;
    }

    @Override
    public boolean setMaxAckIndexes(String topic, String app) throws JoyQueueException {
        StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(topic);
        org.joyqueue.network.session.Consumer consumer = new org.joyqueue.network.session.Consumer();
        consumer.setTopic(topic);
        consumer.setApp(app);
        for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
            for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                this.consume.setAckIndex(consumer, partitionMetric.getPartition(), partitionMetric.getRightIndex());
            }
        }
        return true;
    }

    @Override
    public boolean setAckIndexByTime(String topic, String app, short partition, long timestamp) throws JoyQueueException {
        StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(topic);
        for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
            for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                if (partitionMetric.getPartition() != partition) continue;
                return this.setPartitionAckIndexByTime(topic, app, partitionGroupMetric.getPartitionGroup(), partitionMetric.getPartition(), timestamp);
            }
        }
        return false;
    }

    @Override
    public boolean setAckIndexesByTime(String topic, String app, long timestamp) throws JoyQueueException {
        StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(topic);
        for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
            for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                this.setPartitionAckIndexByTime(topic, app, partitionGroupMetric.getPartitionGroup(), partitionMetric.getPartition(), timestamp);
            }
        }
        return true;
    }

    @Override
    public long getAckIndexByTime(String topic, String app, short partition, long timestamp) {
        StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(topic);
        for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
            for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                if (partitionMetric.getPartition() != partition) continue;
                PartitionGroupStore store = this.storeService.getStore(topic, partitionGroupMetric.getPartitionGroup());
                return store.getIndex(partition, timestamp);
            }
        }
        return -1L;
    }

    @Override
    public List<PartitionAckMonitorInfo> getTopicAckIndexByTime(String topic, String app, long timestamp) {
        ArrayList<PartitionAckMonitorInfo> partitionAckMonitorInfos = new ArrayList<PartitionAckMonitorInfo>();
        StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(topic);
        for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
            PartitionGroupStore store = this.storeService.getStore(topic, partitionGroupMetric.getPartitionGroup());
            for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                PartitionAckMonitorInfo partitionAckMonitorInfo = new PartitionAckMonitorInfo();
                long index = store.getIndex(partitionMetric.getPartition(), timestamp);
                partitionAckMonitorInfo.setIndex(index);
                partitionAckMonitorInfo.setPartition(partitionMetric.getPartition());
                partitionAckMonitorInfos.add(partitionAckMonitorInfo);
            }
        }
        return partitionAckMonitorInfos;
    }

    @Override
    public String initConsumerAckIndexes() throws JoyQueueException {
        HashMap result = Maps.newHashMap();
        for (TopicConfig topicConfig : this.clusterManager.getTopics()) {
            LinkedList apps = Lists.newLinkedList();
            result.put(topicConfig.getName().getFullName(), apps);
            List<Consumer> consumers = this.clusterManager.getLocalConsumersByTopic(topicConfig.getName());
            if (CollectionUtils.isEmpty(consumers)) continue;
            for (PartitionGroup partitionGroup : this.clusterManager.getLocalPartitionGroups(topicConfig)) {
                for (Short partition : partitionGroup.getPartitions()) {
                    for (Consumer consumer : consumers) {
                        apps.add(consumer.getApp());
                        this.consume.setAckIndex(new org.joyqueue.network.session.Consumer(consumer.getTopic().getFullName(), consumer.getApp()), partition, 0L);
                    }
                }
            }
        }
        return JSON.toJSONString((Object)result);
    }

    protected boolean setPartitionAckIndexByTime(String topic, String app, int partitionGroup, short partition, long timestamp) throws JoyQueueException {
        PartitionGroupStore store = this.storeService.getStore(topic, partitionGroup);
        long index = store.getIndex(partition, timestamp);
        if (index < 0L) {
            return false;
        }
        org.joyqueue.network.session.Consumer consumer = new org.joyqueue.network.session.Consumer();
        consumer.setTopic(topic);
        consumer.setApp(app);
        this.consume.setAckIndex(consumer, partition, index);
        return true;
    }
}

