/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage.service.support;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.MessageConvertSupport;
import org.joyqueue.broker.manage.exception.ManageException;
import org.joyqueue.broker.manage.service.MessageManageService;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.SourceType;
import org.joyqueue.monitor.BrokerMessageInfo;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.store.StoreManagementService;

public class DefaultMessageManageService
implements MessageManageService {
    private Consume consume;
    private StoreManagementService storeManagementService;
    private MessageConvertSupport messageConvertSupport;

    public DefaultMessageManageService(Consume consume, StoreManagementService storeManagementService, MessageConvertSupport messageConvertSupport) {
        this.consume = consume;
        this.storeManagementService = storeManagementService;
        this.messageConvertSupport = messageConvertSupport;
    }

    @Override
    public List<BrokerMessageInfo> getPartitionMessage(String topic, String app, short partition, long index, int count) {
        try {
            List<Object> brokerMessages = Lists.newArrayListWithCapacity((int)count);
            ArrayList result = Lists.newArrayListWithCapacity((int)count);
            byte[][] bytes = this.storeManagementService.readMessages(topic, partition, index, count);
            if (ArrayUtils.isNotEmpty((Object[])bytes)) {
                for (byte[] message : bytes) {
                    brokerMessages.add(Serializer.readBrokerMessage(ByteBuffer.wrap(message)));
                }
            }
            brokerMessages = this.messageConvertSupport.convert((List<BrokerMessage>)brokerMessages, SourceType.INTERNAL.getValue());
            Object object = brokerMessages.iterator();
            while (object.hasNext()) {
                BrokerMessage brokerMessage = (BrokerMessage)object.next();
                result.add(new BrokerMessageInfo(brokerMessage));
            }
            return result;
        }
        catch (Exception e) {
            throw new ManageException(e);
        }
    }

    @Override
    public List<BrokerMessageInfo> getPendingMessage(String topic, String app, int count) {
        try {
            Consumer consumer = new Consumer();
            consumer.setTopic(topic);
            consumer.setApp(app);
            ArrayList result = Lists.newArrayListWithCapacity((int)count);
            StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(topic);
            block2: for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
                for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                    int realCount = count - result.size();
                    if (realCount <= 0) continue block2;
                    long ackIndex = this.consume.getAckIndex(consumer, partitionMetric.getPartition());
                    if (ackIndex < 0L) {
                        ackIndex = 0L;
                    }
                    if (ackIndex >= partitionMetric.getRightIndex()) continue;
                    List<Object> brokerMessages = Lists.newLinkedList();
                    byte[][] bytes = this.storeManagementService.readMessages(topic, partitionMetric.getPartition(), ackIndex, realCount);
                    if (ArrayUtils.isNotEmpty((Object[])bytes)) {
                        for (byte[] message : bytes) {
                            BrokerMessage brokerMessage = Serializer.readBrokerMessage(ByteBuffer.wrap(message));
                            brokerMessages.add(brokerMessage);
                        }
                    }
                    brokerMessages = this.messageConvertSupport.convert((List<BrokerMessage>)brokerMessages, SourceType.INTERNAL.getValue());
                    Object object = brokerMessages.iterator();
                    while (object.hasNext()) {
                        BrokerMessage brokerMessage;
                        result.add(new BrokerMessageInfo(brokerMessage, ackIndex > (brokerMessage = (BrokerMessage)object.next()).getMsgIndexNo()));
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ManageException(e);
        }
    }

    @Override
    public List<BrokerMessageInfo> getLastMessage(String topic, String app, int count) {
        try {
            Consumer consumer = new Consumer();
            consumer.setTopic(topic);
            consumer.setApp(app);
            ArrayList result = Lists.newArrayListWithCapacity((int)count);
            StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(topic);
            block2: for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
                for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                    if (partitionMetric.getRightIndex() == 0L) continue;
                    int realCount = count - result.size();
                    if (realCount <= 0) continue block2;
                    long ackIndex = this.consume.getAckIndex(consumer, partitionMetric.getPartition());
                    long realIndex = ackIndex;
                    if (realIndex < 0L) {
                        realIndex = 0L;
                    }
                    if (realIndex >= partitionMetric.getRightIndex()) {
                        realIndex = partitionMetric.getRightIndex() - (long)realCount;
                        realIndex = Math.max(realIndex, 0L);
                    }
                    List<Object> brokerMessages = Lists.newLinkedList();
                    byte[][] bytes = this.storeManagementService.readMessages(topic, partitionMetric.getPartition(), realIndex, realCount);
                    if (ArrayUtils.isNotEmpty((Object[])bytes)) {
                        for (byte[] message : bytes) {
                            BrokerMessage brokerMessage = Serializer.readBrokerMessage(ByteBuffer.wrap(message));
                            brokerMessages.add(brokerMessage);
                        }
                    }
                    brokerMessages = this.messageConvertSupport.convert((List<BrokerMessage>)brokerMessages, SourceType.INTERNAL.getValue());
                    Object object = brokerMessages.iterator();
                    while (object.hasNext()) {
                        BrokerMessage brokerMessage;
                        result.add(new BrokerMessageInfo(brokerMessage, ackIndex > (brokerMessage = (BrokerMessage)object.next()).getMsgIndexNo()));
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ManageException(e);
        }
    }

    @Override
    public List<BrokerMessageInfo> viewMessage(String topic, String app, int count) {
        List<BrokerMessageInfo> pendingMessage = this.getPendingMessage(topic, app, count);
        if (CollectionUtils.isNotEmpty(pendingMessage)) {
            return pendingMessage;
        }
        return this.getLastMessage(topic, app, count);
    }
}

