/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.manage.service.support;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.manage.converter.StoreManageConverter;
import org.joyqueue.broker.manage.service.StoreManageService;
import org.joyqueue.manage.IndexItem;
import org.joyqueue.manage.PartitionGroupMetric;
import org.joyqueue.manage.PartitionMetric;
import org.joyqueue.manage.TopicMetric;
import org.joyqueue.store.StoreManagementService;
import org.joyqueue.store.message.MessageParser;
import org.joyqueue.toolkit.io.Directory;
import org.joyqueue.toolkit.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStoreManageService
implements StoreManageService {
    private Logger logger = LoggerFactory.getLogger(DefaultStoreManageService.class);
    private static final String TOPICS_DIR = "topics";
    private static final String DEL_PREFIX = ".d.";
    private StoreManagementService storeManagementService;

    public DefaultStoreManageService(StoreManagementService storeManagementService) {
        this.storeManagementService = storeManagementService;
    }

    @Override
    public TopicMetric[] topicMetrics() {
        return StoreManageConverter.convert(this.storeManagementService.storeMetrics());
    }

    @Override
    public TopicMetric topicMetric(String topic) {
        return StoreManageConverter.convert(this.storeManagementService.topicMetric(topic));
    }

    @Override
    public PartitionGroupMetric partitionGroupMetric(String topic, int partitionGroup) {
        return StoreManageConverter.convert(this.storeManagementService.partitionGroupMetric(topic, partitionGroup));
    }

    @Override
    public PartitionMetric partitionMetric(String topic, short partition) {
        return StoreManageConverter.convert(this.storeManagementService.partitionMetric(topic, partition));
    }

    @Override
    public File[] listFiles(String path) {
        return this.storeManagementService.listFiles(path);
    }

    @Override
    public File[] listAbsolutePathFiles(String path) {
        return this.storeManagementService.listFiles(new File(path));
    }

    @Override
    public void removeTopic(String topic) {
    }

    @Override
    public Directory storeTreeView(boolean recursive) {
        String topics = TOPICS_DIR;
        Directory directory = new Directory();
        directory.setName(topics);
        File[] topicList = this.storeManagementService.listFiles(topics);
        directory.setDirectory(true);
        if (topicList.length > 0) {
            directory.setChildren(new ArrayList());
        }
        Files.sortByName((File[])topicList);
        for (File f : topicList) {
            Directory child = new Directory();
            Files.tree((String)f.getPath(), (boolean)recursive, (Directory)child);
            directory.getChildren().add(child);
        }
        return directory;
    }

    @Override
    public boolean deleteGarbageFile(String fileName, boolean retain) {
        File file = new File(fileName);
        if (file.exists() && file.getName().contains(DEL_PREFIX)) {
            if (retain && file.isDirectory()) {
                for (File f : file.listFiles()) {
                    Files.deleteDirectory((File)f);
                }
            } else {
                Files.deleteDirectory((File)file);
            }
            this.logger.info("delete file {}", (Object)file.getName());
            return true;
        }
        return false;
    }

    @Override
    public List<String> topics() {
        return Arrays.stream(this.storeManagementService.listFiles(TOPICS_DIR)).map(file -> file.getName()).collect(Collectors.toList());
    }

    @Override
    public List<PartitionGroupMetric> partitionGroups(String topic) {
        String partitionGroupPath = "topics/" + topic;
        File[] partitionGroupFiles = this.storeManagementService.listFiles(partitionGroupPath);
        ArrayList<PartitionGroupMetric> partitionGroupMetrics = new ArrayList<PartitionGroupMetric>();
        for (File file : partitionGroupFiles) {
            PartitionGroupMetric partitionGroupMetric = new PartitionGroupMetric();
            String partitionFile = partitionGroupPath + "/" + file.getName() + "/index";
            File[] partitionFiles = this.storeManagementService.listFiles(partitionFile);
            String partitions = Arrays.stream(partitionFiles).map(file1 -> file1.getName()).sorted(Comparator.comparingInt(Integer::valueOf)).collect(Collectors.joining(","));
            if (StringUtils.isNumeric((CharSequence)file.getName())) {
                partitionGroupMetric.setPartitionGroup(Long.valueOf(file.getName()).intValue());
            }
            partitionGroupMetric.setPartitions(partitions);
            partitionGroupMetrics.add(partitionGroupMetric);
        }
        return partitionGroupMetrics;
    }

    @Override
    public List<String> readPartitionGroupMessage(String topic, int partitionGroup, long position, int count) {
        byte[][] messages = this.storeManagementService.readMessages(topic, partitionGroup, position, count);
        LinkedList result = Lists.newLinkedList();
        for (byte[] message : messages) {
            result.add(MessageParser.getString((ByteBuffer)ByteBuffer.wrap(message)));
        }
        return result;
    }

    @Override
    public List<String> readPartitionMessage(String topic, short partition, long index, int count) {
        byte[][] messages = this.storeManagementService.readMessages(topic, partition, index, count);
        LinkedList result = Lists.newLinkedList();
        for (byte[] message : messages) {
            result.add(MessageParser.getString((ByteBuffer)ByteBuffer.wrap(message)));
        }
        return result;
    }

    @Override
    public List<String> readMessage(String file, long position, int count, boolean includeFileHeader) {
        byte[][] messages = this.storeManagementService.readMessages(new File(file), position, count, includeFileHeader);
        LinkedList result = Lists.newLinkedList();
        for (byte[] message : messages) {
            result.add(MessageParser.getString((ByteBuffer)ByteBuffer.wrap(message)));
        }
        return result;
    }

    @Override
    public IndexItem[] readPartitionIndices(String topic, short partition, long index, int count) {
        return StoreManageConverter.convert(this.storeManagementService.readIndices(topic, partition, index, count));
    }

    @Override
    public IndexItem[] readIndices(String file, long position, int count, boolean includeFileHeader) {
        return StoreManageConverter.convert(this.storeManagementService.readIndices(new File(file), position, count, includeFileHeader));
    }

    @Override
    public String readFile(String file, long position, int length) {
        byte[] message = this.storeManagementService.readFile(new File(file), position, length);
        return MessageParser.getString((ByteBuffer)ByteBuffer.wrap(message));
    }

    @Override
    public String readPartitionGroupStore(String topic, int partitionGroup, long position, int length) {
        byte[] message = this.storeManagementService.readPartitionGroupStore(topic, partitionGroup, position, length);
        return MessageParser.getString((ByteBuffer)ByteBuffer.wrap(message));
    }
}

