/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor;

import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.election.ElectionEvent;
import org.joyqueue.broker.election.ElectionNode;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.broker.monitor.BrokerStatManager;
import org.joyqueue.broker.monitor.ConsumerMonitor;
import org.joyqueue.broker.monitor.ProducerMonitor;
import org.joyqueue.broker.monitor.ReplicationMonitor;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.monitor.SessionMonitor;
import org.joyqueue.broker.monitor.config.BrokerMonitorConfig;
import org.joyqueue.broker.monitor.stat.AppStat;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.broker.monitor.stat.ConsumerStat;
import org.joyqueue.broker.monitor.stat.ElectionEventStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.ProducerStat;
import org.joyqueue.broker.monitor.stat.ReplicationStat;
import org.joyqueue.broker.monitor.stat.TopicStat;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.monitor.Client;
import org.joyqueue.network.session.Connection;
import org.joyqueue.nsr.event.RemoveConsumerEvent;
import org.joyqueue.nsr.event.RemovePartitionGroupEvent;
import org.joyqueue.nsr.event.RemoveProducerEvent;
import org.joyqueue.nsr.event.RemoveTopicEvent;
import org.joyqueue.nsr.event.UpdatePartitionGroupEvent;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerMonitor
extends Service
implements ConsumerMonitor,
ProducerMonitor,
ReplicationMonitor,
SessionMonitor,
EventListener<SessionManager.SessionEvent> {
    private static final Logger logger = LoggerFactory.getLogger(BrokerMonitor.class);
    private BrokerMonitorConfig config;
    private SessionManager sessionManager;
    private BrokerStatManager brokerStatManager;
    private ClusterManager clusterManager;
    private BrokerStat brokerStat;

    public BrokerMonitor() {
    }

    public BrokerMonitor(BrokerMonitorConfig config, SessionManager sessionManager, BrokerStatManager brokerStatManager, ClusterManager clusterManager) {
        this.config = config;
        this.sessionManager = sessionManager;
        this.brokerStatManager = brokerStatManager;
        this.clusterManager = clusterManager;
    }

    protected void doStart() throws Exception {
        this.brokerStat = this.brokerStatManager.getBrokerStat();
        this.clearInvalidStat(this.brokerStat);
        this.sessionManager.addListener(this);
        this.clusterManager.addListener(new MonitorMateDataListener());
    }

    protected void clearInvalidStat(BrokerStat brokerStat) {
        Iterator topicIterator = brokerStat.getTopicStats().entrySet().iterator();
        while (topicIterator.hasNext()) {
            TopicStat topicStat = (TopicStat)topicIterator.next().getValue();
            TopicName topic = TopicName.parse((String)topicStat.getTopic());
            TopicConfig topicConfig = this.clusterManager.getTopicConfig(topic);
            if (topicConfig == null || !topicConfig.isReplica(this.clusterManager.getBrokerId().intValue())) {
                topicIterator.remove();
                continue;
            }
            Iterator appIterator = topicStat.getAppStats().entrySet().iterator();
            while (appIterator.hasNext()) {
                boolean isExistProducer;
                Map.Entry appStatEntry = appIterator.next();
                AppStat appStat = (AppStat)appStatEntry.getValue();
                if (StringUtils.isBlank((CharSequence)appStat.getApp())) {
                    appIterator.remove();
                    continue;
                }
                boolean isExistConsumer = this.clusterManager.tryGetConsumer(topic, appStat.getApp()) != null;
                boolean bl = isExistProducer = this.clusterManager.tryGetProducer(topic, appStat.getApp()) != null;
                if (!isExistConsumer && !isExistProducer) {
                    appIterator.remove();
                    continue;
                }
                if (!isExistConsumer) {
                    appStat.getConsumerStat().clear();
                }
                if (isExistProducer) continue;
                appStat.getProducerStat().clear();
            }
        }
    }

    protected void doStop() {
        this.sessionManager.removeListener(this);
    }

    @Override
    public void onPutMessage(String topic, String app, int partitionGroup, short partition, long count, long size, double time) {
        if (!this.config.isEnable()) {
            return;
        }
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        topicStat.getEnQueueStat().mark(time, size, count);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        ProducerStat producerStat = appStat.getProducerStat();
        PartitionGroupStat producerPartitionGroupStat = producerStat.getOrCreatePartitionGroupStat(partitionGroup);
        producerStat.getEnQueueStat().mark(time, size, count);
        producerPartitionGroupStat.getEnQueueStat().mark(time, size, count);
        producerPartitionGroupStat.getOrCreatePartitionStat(partition).getEnQueueStat().mark(time, size, count);
        this.brokerStat.getEnQueueStat().mark(time, size, count);
    }

    @Override
    public ConsumerStat getConsumerStat(String topic, String app) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        return appStat.getConsumerStat();
    }

    @Override
    public void onGetMessage(String topic, String app, int partitionGroup, short partition, long count, long size, double time) {
        if (!this.config.isEnable()) {
            return;
        }
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        topicStat.getDeQueueStat().mark(time, size, count);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        ConsumerStat consumerStat = appStat.getConsumerStat();
        PartitionGroupStat consumerPartitionGroupStat = consumerStat.getOrCreatePartitionGroupStat(partitionGroup);
        consumerStat.getDeQueueStat().mark(time, size, count);
        consumerPartitionGroupStat.getDeQueueStat().mark(time, size, count);
        consumerPartitionGroupStat.getOrCreatePartitionStat(partition).getDeQueueStat().mark(time, size, count);
        consumerPartitionGroupStat.getOrCreatePartitionStat(partition).lastPullTime(SystemClock.now());
        this.brokerStat.getDeQueueStat().mark(time, size, count);
    }

    @Override
    public void onAckMessage(String topic, String app, int partitionGroup, short partition) {
        if (!this.config.isEnable()) {
            return;
        }
        this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app).getConsumerStat().getOrCreatePartitionGroupStat(partitionGroup).getOrCreatePartitionStat(partition).lastAckTime(SystemClock.now());
    }

    @Override
    public void onReplicateMessage(String topic, int partitionGroup, long count, long size, double time) {
        if (!this.config.isEnable()) {
            return;
        }
        ReplicationStat replicationStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreatePartitionGroupStat(partitionGroup).getReplicationStat();
        replicationStat.getReplicaStat().mark(time, size, count);
        this.brokerStat.getReplicationStat().getReplicaStat().mark(time, size, count);
    }

    @Override
    public void onAppendReplicateMessage(String topic, int partitionGroup, long count, long size, double time) {
        if (!this.config.isEnable()) {
            return;
        }
        ReplicationStat replicationStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreatePartitionGroupStat(partitionGroup).getReplicationStat();
        replicationStat.getAppendStat().mark(time, size, count);
        this.brokerStat.getReplicationStat().getAppendStat().mark(time, size, count);
    }

    @Override
    public void onReplicaStateChange(String topic, int partitionGroup, ElectionNode.State newState) {
        if (!this.config.isEnable()) {
            return;
        }
        ReplicationStat replicationStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreatePartitionGroupStat(partitionGroup).getReplicationStat();
        replicationStat.getStat().setState(newState);
        replicationStat.getStat().setTimestamp(SystemClock.now());
    }

    @Override
    public void onGetRetry(String topic, String app, long count, double time) {
        if (!this.config.isEnable()) {
            return;
        }
    }

    @Override
    public void onAddRetry(String topic, String app, long count, double time) {
        if (!this.config.isEnable()) {
            return;
        }
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        appStat.getConsumerStat().getRetryStat().getTotal().mark(time, count);
    }

    @Override
    public void onRetrySuccess(String topic, String app, long count) {
        if (!this.config.isEnable()) {
            return;
        }
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        appStat.getConsumerStat().getRetryStat().getSuccess().mark(count);
    }

    @Override
    public void onRetryFailure(String topic, String app, long count) {
        if (!this.config.isEnable()) {
            return;
        }
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        appStat.getConsumerStat().getRetryStat().getFailure().mark(count);
    }

    @Override
    public void addProducer(org.joyqueue.network.session.Producer producer) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(producer.getTopic());
        AppStat appStat = topicStat.getOrCreateAppStat(producer.getApp());
        Client client = this.brokerStat.getConnectionStat().getConnection(producer.getConnectionId());
        if (client == null) {
            return;
        }
        client.setProducerRole(true);
        appStat.getConnectionStat().addConnection(client);
        appStat.getConnectionStat().incrProducer();
        appStat.getProducerStat().getConnectionStat().addConnection(client);
        appStat.getProducerStat().getConnectionStat().incrProducer();
        topicStat.getConnectionStat().addConnection(client);
        topicStat.getConnectionStat().incrProducer();
        this.brokerStat.getConnectionStat().incrProducer();
    }

    @Override
    public void addConsumer(org.joyqueue.network.session.Consumer consumer) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(consumer.getTopic());
        AppStat appStat = topicStat.getOrCreateAppStat(consumer.getApp());
        Client client = this.brokerStat.getConnectionStat().getConnection(consumer.getConnectionId());
        if (client == null) {
            return;
        }
        client.setConsumerRole(true);
        appStat.getConnectionStat().addConnection(client);
        appStat.getConnectionStat().incrConsumer();
        appStat.getConsumerStat().getConnectionStat().addConnection(client);
        appStat.getConsumerStat().getConnectionStat().incrConsumer();
        topicStat.getConnectionStat().addConnection(client);
        topicStat.getConnectionStat().incrConsumer();
        this.brokerStat.getConnectionStat().incrConsumer();
    }

    @Override
    public void removeProducer(org.joyqueue.network.session.Producer producer) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(producer.getTopic());
        AppStat appStat = topicStat.getOrCreateAppStat(producer.getApp());
        if (!appStat.getConnectionStat().removeConnection(producer.getConnectionId())) {
            return;
        }
        appStat.getConnectionStat().removeConnection(producer.getConnectionId());
        appStat.getConnectionStat().decrProducer();
        appStat.getProducerStat().getConnectionStat().removeConnection(producer.getConnectionId());
        appStat.getProducerStat().getConnectionStat().decrProducer();
        topicStat.getConnectionStat().removeConnection(producer.getConnectionId());
        topicStat.getConnectionStat().decrProducer();
        this.brokerStat.getConnectionStat().decrProducer();
    }

    @Override
    public void removeConsumer(org.joyqueue.network.session.Consumer consumer) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(consumer.getTopic());
        AppStat appStat = topicStat.getOrCreateAppStat(consumer.getApp());
        if (!appStat.getConnectionStat().removeConnection(consumer.getConnectionId())) {
            return;
        }
        appStat.getConnectionStat().removeConnection(consumer.getConnectionId());
        appStat.getConnectionStat().decrConsumer();
        appStat.getConsumerStat().getConnectionStat().removeConnection(consumer.getConnectionId());
        appStat.getConsumerStat().getConnectionStat().decrConsumer();
        topicStat.getConnectionStat().removeConnection(consumer.getConnectionId());
        topicStat.getConnectionStat().decrConsumer();
        this.brokerStat.getConnectionStat().decrConsumer();
    }

    @Override
    public int getProducer(String topic, String app) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        return appStat.getProducerStat().getConnectionStat().getProducer();
    }

    @Override
    public int getConsumer(String topic, String app) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        return appStat.getProducerStat().getConnectionStat().getConsumer();
    }

    @Override
    public void addConnection(Connection connection) {
        InetSocketAddress address = IpUtil.toAddress((byte[])connection.getAddress());
        Client client = new Client();
        client.setConnectionId(connection.getId());
        client.setApp(connection.getApp());
        client.setLanguage(connection.getLanguage().name());
        client.setVersion(connection.getVersion());
        client.setSource(connection.getSource());
        client.setRegion(connection.getRegion());
        client.setNamespace(connection.getNamespace());
        client.setCreateTime(connection.getCreateTime());
        client.setAuth(connection.isAuth());
        if (address != null && address.getAddress() != null) {
            client.setIp(address.getAddress().getHostAddress());
            client.setPort(address.getPort());
        }
        if (!this.brokerStat.getConnectionStat().addConnection(client)) {
            return;
        }
    }

    @Override
    public void removeConnection(Connection connection) {
        if (!this.brokerStat.getConnectionStat().removeConnection(connection.getId())) {
            return;
        }
        this.sessionManager.removeProducer(connection);
        this.sessionManager.removeConsumer(connection);
    }

    @Override
    public List<Client> getConnections(String topic, String app) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        return Lists.newArrayList(appStat.getConnectionStat().getConnectionMap().values());
    }

    public void onEvent(SessionManager.SessionEvent event) {
        SessionManager.SessionEventType eventType = event.getType();
        switch (eventType) {
            case AddConnection: {
                this.addConnection(event.getConnection());
                break;
            }
            case RemoveConnection: {
                this.removeConnection(event.getConnection());
            }
            case AddProducer: {
                this.addProducer(event.getProducer());
                break;
            }
            case RemoveProducer: {
                this.removeProducer(event.getProducer());
                break;
            }
            case AddConsumer: {
                this.addConsumer(event.getConsumer());
                break;
            }
            case RemoveConsumer: {
                this.removeConsumer(event.getConsumer());
            }
        }
    }

    public BrokerStat getBrokerStat() {
        return this.brokerStat;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    class MonitorMateDataListener
    implements EventListener<MetaEvent> {
        MonitorMateDataListener() {
        }

        public void onEvent(MetaEvent event) {
            switch (event.getEventType()) {
                case REMOVE_CONSUMER: {
                    this.removeConsumer((RemoveConsumerEvent)event);
                    break;
                }
                case REMOVE_PRODUCER: {
                    this.removeProducer((RemoveProducerEvent)event);
                    break;
                }
                case REMOVE_TOPIC: {
                    this.removeTopic((RemoveTopicEvent)event);
                    break;
                }
                case REMOVE_PARTITION_GROUP: {
                    this.removePartitionGroup((RemovePartitionGroupEvent)event);
                    break;
                }
                case UPDATE_PARTITION_GROUP: {
                    this.updatePartitionGroup((UpdatePartitionGroupEvent)event);
                }
            }
        }

        private void removeConsumer(RemoveConsumerEvent removeConsumerEvent) {
            try {
                Consumer consumer = removeConsumerEvent.getConsumer();
                TopicStat topicStat = (TopicStat)BrokerMonitor.this.brokerStat.getTopicStats().get(consumer.getTopic().getFullName());
                if (topicStat == null) {
                    return;
                }
                AppStat appStat = (AppStat)topicStat.getAppStats().get(consumer.getApp());
                if (appStat != null) {
                    appStat.getConsumerStat().clear();
                    if (BrokerMonitor.this.clusterManager.tryGetProducer(consumer.getTopic(), consumer.getApp()) == null) {
                        topicStat.getAppStats().remove(consumer.getApp());
                    }
                }
            }
            catch (Throwable th) {
                logger.error("listen remove consumer event exception, topic: {}, app: {}", new Object[]{removeConsumerEvent.getConsumer().getTopic(), removeConsumerEvent.getConsumer().getApp(), th});
            }
        }

        private void removeProducer(RemoveProducerEvent removeProducerEvent) {
            try {
                Producer producer = removeProducerEvent.getProducer();
                TopicStat topicStat = (TopicStat)BrokerMonitor.this.brokerStat.getTopicStats().get(producer.getTopic().getFullName());
                if (topicStat == null) {
                    return;
                }
                AppStat appStat = (AppStat)topicStat.getAppStats().get(producer.getApp());
                if (appStat != null) {
                    appStat.getProducerStat().clear();
                    if (BrokerMonitor.this.clusterManager.tryGetConsumer(producer.getTopic(), producer.getApp()) == null) {
                        topicStat.getAppStats().remove(producer.getApp());
                    }
                }
            }
            catch (Throwable th) {
                logger.error("listen remove producer event exception, topic: {}, app: {}", new Object[]{removeProducerEvent.getProducer().getTopic(), removeProducerEvent.getProducer().getApp(), th});
            }
        }

        private void removeTopic(RemoveTopicEvent removeTopicEvent) {
            try {
                BrokerMonitor.this.brokerStat.getTopicStats().remove(removeTopicEvent.getTopic().getName().getFullName());
            }
            catch (Throwable th) {
                logger.error("listen remove topic event exception, topic: {}", (Object)removeTopicEvent.getTopic(), (Object)th);
            }
        }

        private void removePartitionGroup(RemovePartitionGroupEvent removePartitionGroupEvent) {
            try {
                TopicStat topicStat = (TopicStat)BrokerMonitor.this.brokerStat.getTopicStats().get(removePartitionGroupEvent.getPartitionGroup().getTopic().getFullName());
                if (topicStat == null) {
                    return;
                }
                topicStat.removePartitionGroup(removePartitionGroupEvent.getPartitionGroup().getGroup());
            }
            catch (Throwable th) {
                logger.error("listen remove partition group event exception, topic: {}, partitionGroup: {}", new Object[]{removePartitionGroupEvent.getPartitionGroup().getTopic(), removePartitionGroupEvent.getPartitionGroup().getGroup(), th});
            }
        }

        private void updatePartitionGroup(UpdatePartitionGroupEvent updatePartitionGroupEvent) {
            try {
                TopicStat topicStat = (TopicStat)BrokerMonitor.this.brokerStat.getTopicStats().get(updatePartitionGroupEvent.getTopic().getFullName());
                if (topicStat == null) {
                    return;
                }
                PartitionGroup oldPartitionGroup = updatePartitionGroupEvent.getOldPartitionGroup();
                PartitionGroup newPartitionGroup = updatePartitionGroupEvent.getNewPartitionGroup();
                for (Short partition : oldPartitionGroup.getPartitions()) {
                    if (newPartitionGroup.getPartitions().contains(partition)) continue;
                    topicStat.removePartition(partition);
                }
            }
            catch (Throwable th) {
                logger.error("listen update partition event exception, topic: {}, partitionGroup: {}.", new Object[]{updatePartitionGroupEvent.getTopic(), updatePartitionGroupEvent.getNewPartitionGroup().getGroup(), th});
            }
        }
    }

    public class ElectionListener
    implements EventListener<ElectionEvent> {
        public void onEvent(ElectionEvent event) {
            TopicPartitionGroup partitionGroup = event.getTopicPartitionGroup();
            if (partitionGroup != null) {
                PartitionGroupStat partitionGroupStat = BrokerMonitor.this.brokerStat.getOrCreateTopicStat(partitionGroup.getTopic()).getOrCreatePartitionGroupStat(partitionGroup.getPartitionGroupId());
                ElectionEventStat electionStat = partitionGroupStat.getElectionEventStat();
                electionStat.setState(event.getEventType());
                electionStat.setTerm(event.getTerm());
                electionStat.setTimestamp(SystemClock.now());
            }
        }
    }
}

