/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor;

import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.monitor.BrokerMonitor;
import org.joyqueue.broker.monitor.BrokerMonitorSlicer;
import org.joyqueue.broker.monitor.BrokerStatManager;
import org.joyqueue.broker.monitor.BrokerStatSaveScheduler;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.monitor.config.BrokerMonitorConfig;
import org.joyqueue.toolkit.service.Service;

public class BrokerMonitorService
extends Service {
    private BrokerMonitorConfig config;
    private SessionManager sessionManager;
    private BrokerMonitor brokerMonitor;
    private BrokerStatManager brokerStatManager;
    private BrokerStatSaveScheduler brokerStatSaveScheduler;
    private BrokerMonitorSlicer brokerMonitorSlicer;

    public BrokerMonitorService(Integer brokerId, BrokerMonitorConfig config, SessionManager sessionManager, ClusterManager clusterManager) {
        this.config = config;
        this.sessionManager = sessionManager;
        this.brokerStatManager = new BrokerStatManager(brokerId, config);
        this.brokerMonitor = new BrokerMonitor(config, sessionManager, this.brokerStatManager, clusterManager);
        this.brokerStatSaveScheduler = new BrokerStatSaveScheduler(config, this.brokerStatManager);
        this.brokerMonitorSlicer = new BrokerMonitorSlicer(this.brokerMonitor);
    }

    protected void doStart() throws Exception {
        this.brokerStatManager.start();
        this.brokerMonitor.start();
        this.brokerStatSaveScheduler.start();
        this.brokerMonitorSlicer.start();
    }

    protected void doStop() {
        this.brokerStatManager.stop();
        this.brokerStatSaveScheduler.stop();
        this.brokerMonitor.stop();
        this.brokerMonitorSlicer.stop();
    }

    public BrokerMonitor getBrokerMonitor() {
        return this.brokerMonitor;
    }

    public BrokerMonitorConfig getConfig() {
        return this.config;
    }
}

