/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.monitor.BrokerMonitor;
import org.joyqueue.broker.monitor.stat.AppStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.PartitionStat;
import org.joyqueue.broker.monitor.stat.TopicStat;
import org.joyqueue.toolkit.service.Service;

public class BrokerMonitorSlicer
extends Service
implements Runnable {
    private BrokerMonitor brokerMonitor;
    private ScheduledExecutorService sliceThread;

    public BrokerMonitorSlicer(BrokerMonitor brokerMonitor) {
        this.brokerMonitor = brokerMonitor;
    }

    protected void validate() throws Exception {
        this.sliceThread = Executors.newScheduledThreadPool(1);
    }

    protected void doStart() throws Exception {
        this.sliceThread.scheduleWithFixedDelay(this, 0L, 60000L, TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        this.sliceThread.shutdown();
    }

    @Override
    public void run() {
        for (Map.Entry topicEntry : this.brokerMonitor.getBrokerStat().getTopicStats().entrySet()) {
            TopicStat topicStat = (TopicStat)topicEntry.getValue();
            topicStat.getEnQueueStat().slice();
            topicStat.getDeQueueStat().slice();
            for (Map.Entry partitionGroupStatEntry : topicStat.getPartitionGroupStatMap().entrySet()) {
                ((PartitionGroupStat)partitionGroupStatEntry.getValue()).getEnQueueStat().slice();
                ((PartitionGroupStat)partitionGroupStatEntry.getValue()).getDeQueueStat().slice();
                ((PartitionGroupStat)partitionGroupStatEntry.getValue()).getReplicationStat().getReplicaStat().slice();
                ((PartitionGroupStat)partitionGroupStatEntry.getValue()).getReplicationStat().getAppendStat().slice();
                for (Map.Entry partitionStatEntry : ((PartitionGroupStat)partitionGroupStatEntry.getValue()).getPartitionStatMap().entrySet()) {
                    ((PartitionStat)partitionStatEntry.getValue()).getEnQueueStat().slice();
                    ((PartitionStat)partitionStatEntry.getValue()).getDeQueueStat().slice();
                }
            }
            for (Map.Entry appEntry : topicStat.getAppStats().entrySet()) {
                AppStat appStat = (AppStat)appEntry.getValue();
                appStat.getProducerStat().getEnQueueStat().slice();
                appStat.getConsumerStat().getDeQueueStat().slice();
                for (Map.Entry partitionGroupEntry : appStat.getPartitionGroupStatMap().entrySet()) {
                    ((PartitionGroupStat)partitionGroupEntry.getValue()).getEnQueueStat().slice();
                    ((PartitionGroupStat)partitionGroupEntry.getValue()).getDeQueueStat().slice();
                    for (Map.Entry partitionEntry : ((PartitionGroupStat)partitionGroupEntry.getValue()).getPartitionStatMap().entrySet()) {
                        ((PartitionStat)partitionEntry.getValue()).getEnQueueStat().slice();
                        ((PartitionStat)partitionEntry.getValue()).getDeQueueStat().slice();
                    }
                }
                for (Map.Entry partitionGroupEntry : appStat.getProducerStat().getPartitionGroupStatMap().entrySet()) {
                    ((PartitionGroupStat)partitionGroupEntry.getValue()).getEnQueueStat().slice();
                    ((PartitionGroupStat)partitionGroupEntry.getValue()).getDeQueueStat().slice();
                    for (Map.Entry partitionEntry : ((PartitionGroupStat)partitionGroupEntry.getValue()).getPartitionStatMap().entrySet()) {
                        ((PartitionStat)partitionEntry.getValue()).getEnQueueStat().slice();
                        ((PartitionStat)partitionEntry.getValue()).getDeQueueStat().slice();
                    }
                }
                for (Map.Entry partitionGroupEntry : appStat.getConsumerStat().getPartitionGroupStatMap().entrySet()) {
                    ((PartitionGroupStat)partitionGroupEntry.getValue()).getEnQueueStat().slice();
                    ((PartitionGroupStat)partitionGroupEntry.getValue()).getDeQueueStat().slice();
                    for (Map.Entry partitionEntry : ((PartitionGroupStat)partitionGroupEntry.getValue()).getPartitionStatMap().entrySet()) {
                        ((PartitionStat)partitionEntry.getValue()).getEnQueueStat().slice();
                        ((PartitionStat)partitionEntry.getValue()).getDeQueueStat().slice();
                    }
                }
            }
        }
        this.brokerMonitor.getBrokerStat().getJvmStat().snapshot();
        this.brokerMonitor.getBrokerStat().getReplicationStat().getAppendStat().slice();
        this.brokerMonitor.getBrokerStat().getReplicationStat().getReplicaStat().slice();
        this.brokerMonitor.getBrokerStat().getEnQueueStat().slice();
        this.brokerMonitor.getBrokerStat().getDeQueueStat().slice();
    }
}

