/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.monitor.config.BrokerMonitorConfig;
import org.joyqueue.broker.monitor.converter.BrokerStatConverter;
import org.joyqueue.broker.monitor.exception.MonitorException;
import org.joyqueue.broker.monitor.model.BrokerStatPo;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.toolkit.io.DoubleCopy;
import org.joyqueue.toolkit.io.ZipUtil;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerStatManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(BrokerStatManager.class);
    private static final int DEFAULT_FILE_SIZE = 0x6400000;
    private Integer brokerId;
    private BrokerMonitorConfig config;
    private BrokerStat brokerStat;
    private File statFile;
    private File newStatFile;
    private BrokerStatDoubleCopy brokerStatDoubleCopy;

    public BrokerStatManager(Integer brokerId, BrokerMonitorConfig config) {
        this.brokerId = brokerId;
        this.config = config;
        this.statFile = new File(config.getStatSaveFile());
        this.newStatFile = new File(config.getStatSaveFileNew());
        try {
            this.brokerStatDoubleCopy = new BrokerStatDoubleCopy(brokerId, config, this.newStatFile);
            this.brokerStat = this.recover();
        }
        catch (IOException e) {
            throw new MonitorException(e);
        }
    }

    protected BrokerStat recover() throws IOException {
        if (this.newStatFile.exists()) {
            this.brokerStatDoubleCopy.recover();
            BrokerStat brokerStat = this.brokerStatDoubleCopy.getBrokerStat();
            return brokerStat;
        }
        if (!this.statFile.exists()) {
            return new BrokerStat(this.brokerId);
        }
        String stat = FileUtils.readFileToString((File)this.statFile);
        if (StringUtils.isBlank((CharSequence)stat)) {
            return new BrokerStat(this.brokerId);
        }
        BrokerStatPo brokerStatPo = (BrokerStatPo)JSON.parseObject((String)stat, BrokerStatPo.class);
        if (brokerStatPo.getVersion() != 1) {
            logger.warn("broker stat check version failed, current: {}, required: {}", (Object)brokerStatPo.getVersion(), (Object)1);
            return new BrokerStat(this.brokerId);
        }
        brokerStatPo.setBrokerId(this.brokerId);
        return BrokerStatConverter.convert(brokerStatPo);
    }

    protected void doStop() {
        this.brokerStatDoubleCopy.flush();
    }

    public BrokerStat getBrokerStat() {
        return this.brokerStat;
    }

    public void save() {
        this.brokerStatDoubleCopy.flush();
    }

    public static class BrokerStatDoubleCopy
    extends DoubleCopy {
        private Integer brokerId;
        private BrokerMonitorConfig config;
        private File statFile;
        private BrokerStat brokerStat;

        public BrokerStatDoubleCopy(Integer brokerId, BrokerMonitorConfig config, File statFile) throws IOException {
            super(statFile, 0x6400000);
            this.brokerId = brokerId;
            this.config = config;
            this.statFile = statFile;
            this.brokerStat = new BrokerStat(brokerId);
        }

        protected String getName() {
            return "BrokerStat";
        }

        protected byte[] serialize() {
            try {
                BrokerStatPo brokerStatPo = BrokerStatConverter.convertToPo(this.brokerStat);
                byte[] stat = JSON.toJSONBytes((Object)brokerStatPo, (SerializerFeature[])new SerializerFeature[0]);
                stat = ZipUtil.compress((byte[])stat);
                if (logger.isDebugEnabled()) {
                    logger.debug("save broker stat, value: {}, file: {}", (Object)new String(stat), (Object)this.statFile);
                }
                return stat;
            }
            catch (Exception e) {
                logger.error("serialize stat exception", (Throwable)e);
                return new byte[0];
            }
        }

        protected void parse(byte[] data) {
            try {
                BrokerStatPo brokerStatPo;
                if (logger.isDebugEnabled()) {
                    logger.debug("load broker stat, value: {}, file: {}", (Object)new String(data), (Object)this.statFile);
                }
                if ((brokerStatPo = (BrokerStatPo)JSON.parseObject((byte[])(data = ZipUtil.decompress((byte[])data).getBytes()), BrokerStatPo.class, (Feature[])new Feature[0])).getVersion() != 1) {
                    logger.warn("broker stat check version failed, current: {}, required: {}", (Object)brokerStatPo.getVersion(), (Object)1);
                    this.brokerStat = new BrokerStat(this.brokerId);
                    return;
                }
                brokerStatPo.setBrokerId(this.brokerId);
                this.brokerStat = BrokerStatConverter.convert(brokerStatPo);
            }
            catch (Exception e) {
                logger.error("load broker stat exception, statFile: {}", (Object)this.statFile, (Object)e);
                throw new MonitorException("load broker stat exception", e);
            }
        }

        public BrokerStat getBrokerStat() {
            return this.brokerStat;
        }
    }
}

