/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.monitor.BrokerStatManager;
import org.joyqueue.broker.monitor.config.BrokerMonitorConfig;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerStatSaveScheduler
extends Service
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(BrokerStatSaveScheduler.class);
    private BrokerMonitorConfig config;
    private BrokerStatManager brokerStatManager;
    private ScheduledExecutorService executorService;

    public BrokerStatSaveScheduler(BrokerMonitorConfig config, BrokerStatManager brokerStatManager) {
        this.config = config;
        this.brokerStatManager = brokerStatManager;
        this.executorService = this.newScheduledExecutorService();
    }

    protected void doStart() throws Exception {
        this.executorService.scheduleWithFixedDelay(this, this.config.getStatSaveInterval(), this.config.getStatSaveInterval(), TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        this.executorService.shutdown();
    }

    @Override
    public void run() {
        try {
            this.brokerStatManager.save();
        }
        catch (Exception e) {
            logger.error("save broker stat exception", (Throwable)e);
        }
    }

    protected ScheduledExecutorService newScheduledExecutorService() {
        NamedThreadFactory threadFactory = new NamedThreadFactory("joyqueue-stat-save-scheduler");
        return Executors.newSingleThreadScheduledExecutor((ThreadFactory)threadFactory);
    }
}

