/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
extends Service {
    private static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    public static final String CONNECTION_KEY = "connection";
    public static final String USER_KEY = "user";
    private ConcurrentMap<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private ConcurrentMap<String, Producer> producers = new ConcurrentHashMap<String, Producer>();
    private ConcurrentMap<String, Consumer> consumers = new ConcurrentHashMap<String, Consumer>();
    private EventBus<SessionEvent> eventManager = new EventBus("joyqueue-frontend-session-eventBus");

    protected void doStart() throws Exception {
        this.eventManager.start();
        logger.info("session manager is started");
    }

    protected void doStop() {
        this.eventManager.stop();
        logger.info("session manager is stopped");
    }

    public Consumer getConsumerByTopic(String connectionId, String topic) {
        for (Map.Entry entry : this.consumers.entrySet()) {
            Consumer consumer = (Consumer)entry.getValue();
            if (!consumer.getConnectionId().equals(connectionId) || !consumer.getTopic().equals(topic)) continue;
            return consumer;
        }
        return null;
    }

    public boolean addConnection(Connection connection) {
        if (connection == null) {
            return false;
        }
        if (this.connections.putIfAbsent(connection.getId(), connection) == null) {
            this.eventManager.inform((Object)new SessionEvent(SessionEventType.AddConnection, connection));
            if (logger.isDebugEnabled()) {
                logger.debug("add connection :" + connection.getId());
            }
            return true;
        }
        return false;
    }

    public void removeConnection(String connectionId) {
        Connection connection = (Connection)this.connections.remove(connectionId);
        if (connection == null) {
            return;
        }
        this.removeConsumer(connection);
        this.removeProducer(connection);
        this.eventManager.add((Object)new SessionEvent(SessionEventType.RemoveConnection, connection));
    }

    protected void removeProducer(Connection connection) {
        if (connection == null) {
            return;
        }
        for (Map.Entry entry : connection.getProducers().entrySet()) {
            for (Map.Entry producerEntry : ((ConcurrentMap)entry.getValue()).entrySet()) {
                Producer producer = (Producer)this.producers.remove(producerEntry.getValue());
                if (producer == null) continue;
                this.eventManager.add((Object)new SessionEvent(SessionEventType.RemoveProducer, producer));
            }
        }
    }

    protected void removeConsumer(Connection connection) {
        if (connection == null) {
            return;
        }
        for (Map.Entry entry : connection.getConsumers().entrySet()) {
            for (Map.Entry consumerEntry : ((ConcurrentMap)entry.getValue()).entrySet()) {
                Consumer consumer = (Consumer)this.consumers.remove(consumerEntry.getValue());
                if (consumer == null) continue;
                this.eventManager.add((Object)new SessionEvent(SessionEventType.RemoveConsumer, consumer));
            }
        }
    }

    public List<Connection> getConnection() {
        return new ArrayList<Connection>(this.connections.values());
    }

    public Connection getConnectionById(String id) {
        return (Connection)this.connections.get(id);
    }

    public boolean addConsumer(Consumer consumer) {
        if (consumer == null) {
            return false;
        }
        Connection connection = this.getConnectionById(consumer.getConnectionId());
        if (connection == null) {
            return false;
        }
        if (connection.addConsumer(consumer.getTopic(), consumer.getApp(), consumer.getId()) && this.consumers.putIfAbsent(consumer.getId(), consumer) == null) {
            try {
                this.eventManager.inform((Object)new SessionEvent(SessionEventType.AddConsumer, consumer));
            }
            catch (Exception e) {
                logger.error("\u901a\u77e5\u589e\u52a0\u6d88\u8d39\u8005\u5931\u8d25," + e.getMessage(), (Throwable)e);
                this.removeConsumer(consumer.getId());
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("add consumer :" + consumer.getId());
            }
            return true;
        }
        logger.warn(String.format("consumer is already exists. topic=%s app=%s id=%s", consumer.getTopic(), consumer.getApp(), consumer.getId()));
        return true;
    }

    public boolean removeConsumer(String consumerId) {
        Consumer consumer = (Consumer)this.consumers.remove(consumerId);
        if (consumer == null) {
            return false;
        }
        Connection connection = this.getConnectionById(consumer.getConnectionId());
        if (connection == null) {
            return false;
        }
        connection.removeConsumer(consumer.getTopic(), consumer.getApp());
        this.eventManager.add((Object)new SessionEvent(SessionEventType.RemoveConsumer, consumer));
        return true;
    }

    public List<Consumer> getConsumer() {
        return new ArrayList<Consumer>(this.consumers.values());
    }

    public List<Producer> getProducer() {
        return new ArrayList<Producer>(this.producers.values());
    }

    public Consumer getConsumerById(String id) {
        return (Consumer)this.consumers.get(id);
    }

    public boolean addProducer(Producer producer) {
        if (producer == null) {
            return false;
        }
        Connection connection = this.getConnectionById(producer.getConnectionId());
        if (connection == null) {
            return false;
        }
        if (connection.addProducer(producer.getTopic(), producer.getApp(), producer.getId()) && this.producers.putIfAbsent(producer.getId(), producer) == null) {
            try {
                this.eventManager.inform((Object)new SessionEvent(SessionEventType.AddProducer, producer));
            }
            catch (Exception e) {
                this.removeProducer(producer.getId());
                logger.error("\u901a\u77e5\u751f\u4ea7\u8005\u589e\u52a0\u5931\u8d25," + e.getMessage(), (Throwable)e);
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("add producer" + producer.getId());
            }
            return true;
        }
        logger.warn(String.format("producer is already exists. topic=%s app=%s id=%s", producer.getTopic(), producer.getApp(), producer.getId()));
        return true;
    }

    public boolean removeProducer(String producerId) {
        Producer producer = (Producer)this.producers.remove(producerId);
        if (producer == null) {
            return false;
        }
        Connection connection = this.getConnectionById(producer.getConnectionId());
        if (connection == null) {
            return false;
        }
        connection.removeProducer(producer.getTopic(), producer.getApp());
        this.eventManager.add((Object)new SessionEvent(SessionEventType.RemoveProducer, producer));
        return true;
    }

    public Producer getProducerById(String id) {
        return (Producer)this.producers.get(id);
    }

    public void addListener(EventListener<SessionEvent> listener) {
        if (listener != null) {
            this.eventManager.addListener(listener);
        }
    }

    public void removeListener(EventListener<SessionEvent> listener) {
        if (listener != null) {
            this.eventManager.removeListener(listener);
        }
    }

    public void closeProducer(String topic, String app) {
        HashSet<String> connectionIds = new HashSet<String>(20);
        for (Map.Entry entry : this.producers.entrySet()) {
            String connectionId;
            Producer producer = (Producer)entry.getValue();
            if (!producer.getTopic().equals(topic) || !producer.getApp().equals(app) || !connectionIds.add(connectionId = producer.getConnectionId())) continue;
            this.closeRelatedTransport(connectionId);
        }
    }

    public void closeConsumer(String topic, String app) {
        HashSet<String> connectionIds = new HashSet<String>(20);
        for (Map.Entry entry : this.consumers.entrySet()) {
            String connectionId;
            Consumer consumer = (Consumer)entry.getValue();
            if (topic != null && !consumer.getTopic().equals(topic) || app != null && !consumer.getApp().equals(app) || !connectionIds.add(connectionId = consumer.getConnectionId())) continue;
            this.closeRelatedTransport(connectionId);
        }
    }

    private void closeRelatedTransport(String connectionId) {
        Transport transport;
        Connection connection = (Connection)this.connections.get(connectionId);
        if (connection != null && (transport = connection.getTransport()) != null) {
            transport.stop();
        }
    }

    public static class SessionEvent {
        private SessionEventType type;
        private Connection connection;
        private Consumer consumer;
        private Producer producer;

        public SessionEvent(SessionEventType type, Connection connection) {
            this.type = type;
            this.connection = connection;
        }

        public SessionEvent(SessionEventType type, Consumer consumer) {
            this.type = type;
            this.consumer = consumer;
        }

        public SessionEvent(SessionEventType type, Producer producer) {
            this.type = type;
            this.producer = producer;
        }

        public SessionEventType getType() {
            return this.type;
        }

        public void setType(SessionEventType type) {
            this.type = type;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }

        public void setConsumer(Consumer consumer) {
            this.consumer = consumer;
        }

        public Producer getProducer() {
            return this.producer;
        }

        public void setProducer(Producer producer) {
            this.producer = producer;
        }

        public String toString() {
            return "SessionEvent{type=" + (Object)((Object)this.type) + ", connection=" + this.connection + ", consumer=" + this.consumer + ", producer=" + this.producer + '}';
        }
    }

    public static enum SessionEventType {
        AddConnection,
        RemoveConnection,
        AddProducer,
        RemoveProducer,
        AddConsumer,
        RemoveConsumer;

    }
}

