/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.converter;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.broker.monitor.model.AppStatPo;
import org.joyqueue.broker.monitor.model.BasePo;
import org.joyqueue.broker.monitor.model.BrokerStatPo;
import org.joyqueue.broker.monitor.model.ConsumerStatPo;
import org.joyqueue.broker.monitor.model.DeQueueStatPo;
import org.joyqueue.broker.monitor.model.EnQueueStatPo;
import org.joyqueue.broker.monitor.model.PartitionGroupStatPo;
import org.joyqueue.broker.monitor.model.PartitionStatPo;
import org.joyqueue.broker.monitor.model.ProducerStatPo;
import org.joyqueue.broker.monitor.model.ReplicationStatPo;
import org.joyqueue.broker.monitor.model.RetryStatPo;
import org.joyqueue.broker.monitor.model.TopicStatPo;
import org.joyqueue.broker.monitor.stat.AppStat;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.PartitionStat;
import org.joyqueue.broker.monitor.stat.RetryStat;
import org.joyqueue.broker.monitor.stat.TopicStat;

public class BrokerStatConverter {
    public static BrokerStatPo convertToPo(BrokerStat brokerStat) {
        BrokerStatPo brokerStatPo = new BrokerStatPo();
        HashMap topicStatPoMap = Maps.newHashMap();
        brokerStatPo.setVersion(1);
        brokerStatPo.setTopicStatMap(topicStatPoMap);
        brokerStatPo.setEnQueueStat(new EnQueueStatPo(brokerStat.getEnQueueStat().getTotal(), brokerStat.getEnQueueStat().getTotalSize()));
        brokerStatPo.setDeQueueStat(new DeQueueStatPo(brokerStat.getDeQueueStat().getTotal(), brokerStat.getDeQueueStat().getTotalSize()));
        brokerStatPo.setReplicationStat(new ReplicationStatPo(new EnQueueStatPo(brokerStat.getReplicationStat().getReplicaStat().getTotal(), brokerStat.getReplicationStat().getReplicaStat().getTotalSize()), new EnQueueStatPo(brokerStat.getReplicationStat().getAppendStat().getTotal(), brokerStat.getReplicationStat().getAppendStat().getTotalSize())));
        for (Map.Entry topicStatEntry : brokerStat.getTopicStats().entrySet()) {
            TopicStat topicStat = (TopicStat)topicStatEntry.getValue();
            TopicStatPo topicStatPo = new TopicStatPo();
            HashMap appStatPoMap = Maps.newHashMap();
            topicStatPoMap.put(topicStat.getTopic(), topicStatPo);
            topicStatPo.setAppStatMap(appStatPoMap);
            topicStatPo.setEnQueueStat(new EnQueueStatPo(topicStat.getEnQueueStat().getTotal(), topicStat.getEnQueueStat().getTotalSize()));
            topicStatPo.setDeQueueStat(new DeQueueStatPo(topicStat.getDeQueueStat().getTotal(), topicStat.getDeQueueStat().getTotalSize()));
            for (Map.Entry partitionGroupStatEntry : topicStat.getPartitionGroupStatMap().entrySet()) {
                PartitionGroupStatPo partitionGroupStatPo = BrokerStatConverter.convertPartitionGroupStatPo((PartitionGroupStat)partitionGroupStatEntry.getValue());
                topicStatPo.getPartitionGroupStatMap().put((Integer)partitionGroupStatEntry.getKey(), partitionGroupStatPo);
            }
            for (Map.Entry appStatEntry : topicStat.getAppStats().entrySet()) {
                PartitionGroupStatPo partitionGroupStatPo;
                PartitionGroupStat partitionGroupStat;
                AppStat appStat = (AppStat)appStatEntry.getValue();
                RetryStat retryStat = appStat.getConsumerStat().getRetryStat();
                AppStatPo appStatPo = new AppStatPo();
                HashMap partitionGroupStatPoMap = Maps.newHashMap();
                appStatPoMap.put(appStatEntry.getKey(), appStatPo);
                appStatPo.setPartitionGroupStatMap(partitionGroupStatPoMap);
                appStatPo.setConsumerStat(new ConsumerStatPo(new RetryStatPo(retryStat.getTotal().getCount(), retryStat.getSuccess().getCount(), retryStat.getFailure().getCount()), new DeQueueStatPo(appStat.getConsumerStat().getDeQueueStat().getTotal(), appStat.getConsumerStat().getDeQueueStat().getTotalSize())));
                appStatPo.setProducerStat(new ProducerStatPo(new EnQueueStatPo(appStat.getProducerStat().getEnQueueStat().getTotal(), appStat.getProducerStat().getEnQueueStat().getTotalSize())));
                for (Map.Entry partitionGroupStatEntry : appStat.getConsumerStat().getPartitionGroupStatMap().entrySet()) {
                    partitionGroupStat = (PartitionGroupStat)partitionGroupStatEntry.getValue();
                    partitionGroupStatPo = BrokerStatConverter.convertPartitionGroupStatPo(partitionGroupStat);
                    appStatPo.getConsumerStat().getPartitionGroupStatMap().put((Integer)partitionGroupStatEntry.getKey(), partitionGroupStatPo);
                }
                for (Map.Entry partitionGroupStatEntry : appStat.getProducerStat().getPartitionGroupStatMap().entrySet()) {
                    partitionGroupStat = (PartitionGroupStat)partitionGroupStatEntry.getValue();
                    partitionGroupStatPo = BrokerStatConverter.convertPartitionGroupStatPo(partitionGroupStat);
                    appStatPo.getProducerStat().getPartitionGroupStatMap().put((Integer)partitionGroupStatEntry.getKey(), partitionGroupStatPo);
                }
                for (Map.Entry partitionGroupStatEntry : appStat.getPartitionGroupStatMap().entrySet()) {
                    partitionGroupStat = (PartitionGroupStat)partitionGroupStatEntry.getValue();
                    partitionGroupStatPo = BrokerStatConverter.convertPartitionGroupStatPo(partitionGroupStat);
                    partitionGroupStatPoMap.put(partitionGroupStatEntry.getKey(), partitionGroupStatPo);
                }
            }
        }
        return brokerStatPo;
    }

    protected static PartitionGroupStatPo convertPartitionGroupStatPo(PartitionGroupStat partitionGroupStat) {
        PartitionGroupStatPo partitionGroupStatPo = new PartitionGroupStatPo();
        HashMap partitionStatPoMap = Maps.newHashMap();
        partitionGroupStatPo.setPartitionStatMap(partitionStatPoMap);
        partitionGroupStatPo.setEnQueueStat(new EnQueueStatPo(partitionGroupStat.getEnQueueStat().getTotal(), partitionGroupStat.getEnQueueStat().getTotalSize()));
        partitionGroupStatPo.setDeQueueStat(new DeQueueStatPo(partitionGroupStat.getDeQueueStat().getTotal(), partitionGroupStat.getDeQueueStat().getTotalSize()));
        for (Map.Entry partitionStatEntry : partitionGroupStat.getPartitionStatMap().entrySet()) {
            PartitionStat partitionStat = (PartitionStat)partitionStatEntry.getValue();
            PartitionStatPo partitionStatPo = new PartitionStatPo();
            partitionStatPo.setPartition((Short)partitionStatEntry.getKey());
            partitionStatPo.setEnQueueStat(new EnQueueStatPo(partitionStat.getEnQueueStat().getTotal(), partitionStat.getEnQueueStat().getTotalSize()));
            partitionStatPo.setDeQueueStat(new DeQueueStatPo(partitionStat.getDeQueueStat().getTotal(), partitionStat.getDeQueueStat().getTotalSize()));
            partitionStatPoMap.put(partitionStatEntry.getKey(), partitionStatPo);
        }
        partitionGroupStatPo.setReplicationStat(new ReplicationStatPo(new EnQueueStatPo(partitionGroupStat.getReplicationStat().getReplicaStat().getTotal(), partitionGroupStat.getReplicationStat().getReplicaStat().getTotalSize()), new EnQueueStatPo(partitionGroupStat.getReplicationStat().getAppendStat().getTotal(), partitionGroupStat.getReplicationStat().getAppendStat().getTotalSize())));
        return partitionGroupStatPo;
    }

    public static BrokerStat convert(BrokerStatPo brokerStatPo) {
        BrokerStat brokerStat = new BrokerStat(brokerStatPo.getBrokerId());
        brokerStat.getEnQueueStat().setTotal(brokerStatPo.getEnQueueStat().getTotal());
        brokerStat.getDeQueueStat().setTotalSize(brokerStatPo.getEnQueueStat().getTotalSize());
        brokerStat.getReplicationStat().getReplicaStat().setTotal(brokerStatPo.getReplicationStat().getReplicaStat().getTotal());
        brokerStat.getReplicationStat().getReplicaStat().setTotalSize(brokerStatPo.getReplicationStat().getReplicaStat().getTotalSize());
        brokerStat.getReplicationStat().getAppendStat().setTotal(brokerStatPo.getReplicationStat().getAppendStat().getTotal());
        brokerStat.getReplicationStat().getAppendStat().setTotalSize(brokerStatPo.getReplicationStat().getAppendStat().getTotalSize());
        for (Map.Entry<String, TopicStatPo> topicStatPoEntry : brokerStatPo.getTopicStatMap().entrySet()) {
            TopicStatPo topicStatPo = topicStatPoEntry.getValue();
            TopicStat topicStat = brokerStat.getOrCreateTopicStat(topicStatPoEntry.getKey());
            topicStat.getEnQueueStat().setTotal(topicStatPo.getEnQueueStat().getTotal());
            topicStat.getEnQueueStat().setTotalSize(topicStatPo.getEnQueueStat().getTotalSize());
            topicStat.getDeQueueStat().setTotal(topicStatPo.getDeQueueStat().getTotal());
            topicStat.getDeQueueStat().setTotalSize(topicStatPo.getDeQueueStat().getTotalSize());
            for (Map.Entry<Integer, PartitionGroupStatPo> entry : topicStatPo.getPartitionGroupStatMap().entrySet()) {
                PartitionGroupStatPo partitionGroupStatPo = entry.getValue();
                PartitionGroupStat partitionGroupStat = topicStat.getOrCreatePartitionGroupStat(entry.getKey());
                partitionGroupStat = BrokerStatConverter.convert(partitionGroupStat, partitionGroupStatPo);
            }
            for (Map.Entry<Object, BasePo> entry : topicStatPo.getAppStatMap().entrySet()) {
                PartitionGroupStat partitionGroupStat;
                PartitionGroupStatPo partitionGroupStatPo;
                AppStatPo appStatPo = (AppStatPo)entry.getValue();
                RetryStatPo retryStatPo = appStatPo.getConsumerStat().getRetryStat();
                AppStat appStat = topicStat.getOrCreateAppStat((String)entry.getKey());
                appStat.getProducerStat().getEnQueueStat().setTotal(appStatPo.getProducerStat().getEnQueueStat().getTotal());
                appStat.getProducerStat().getEnQueueStat().setTotalSize(appStatPo.getProducerStat().getEnQueueStat().getTotalSize());
                appStat.getConsumerStat().getDeQueueStat().setTotal(appStatPo.getConsumerStat().getDeQueueStat().getTotal());
                appStat.getConsumerStat().getDeQueueStat().setTotalSize(appStatPo.getConsumerStat().getDeQueueStat().getTotalSize());
                appStat.getConsumerStat().getRetryStat().getTotal().setCount(retryStatPo.getTotal());
                appStat.getConsumerStat().getRetryStat().getSuccess().setCount(retryStatPo.getSuccess());
                appStat.getConsumerStat().getRetryStat().getFailure().setCount(retryStatPo.getFailure());
                for (Map.Entry<Integer, PartitionGroupStatPo> partitionGroupStatPoEntry : appStatPo.getConsumerStat().getPartitionGroupStatMap().entrySet()) {
                    partitionGroupStatPo = partitionGroupStatPoEntry.getValue();
                    partitionGroupStat = appStat.getConsumerStat().getOrCreatePartitionGroupStat(partitionGroupStatPoEntry.getKey());
                    partitionGroupStat = BrokerStatConverter.convert(partitionGroupStat, partitionGroupStatPo);
                }
                for (Map.Entry<Integer, PartitionGroupStatPo> partitionGroupStatPoEntry : appStatPo.getProducerStat().getPartitionGroupStatMap().entrySet()) {
                    partitionGroupStatPo = partitionGroupStatPoEntry.getValue();
                    partitionGroupStat = appStat.getProducerStat().getOrCreatePartitionGroupStat(partitionGroupStatPoEntry.getKey());
                    partitionGroupStat = BrokerStatConverter.convert(partitionGroupStat, partitionGroupStatPo);
                }
                for (Map.Entry<Integer, PartitionGroupStatPo> partitionGroupStatPoEntry : appStatPo.getPartitionGroupStatMap().entrySet()) {
                    partitionGroupStatPo = partitionGroupStatPoEntry.getValue();
                    partitionGroupStat = appStat.getOrCreatePartitionGroupStat(partitionGroupStatPoEntry.getKey());
                    partitionGroupStat = BrokerStatConverter.convert(partitionGroupStat, partitionGroupStatPo);
                }
            }
        }
        return brokerStat;
    }

    protected static PartitionGroupStat convert(PartitionGroupStat partitionGroupStat, PartitionGroupStatPo partitionGroupStatPo) {
        partitionGroupStat.getEnQueueStat().setTotal(partitionGroupStatPo.getEnQueueStat().getTotal());
        partitionGroupStat.getEnQueueStat().setTotalSize(partitionGroupStatPo.getEnQueueStat().getTotalSize());
        partitionGroupStat.getDeQueueStat().setTotal(partitionGroupStatPo.getDeQueueStat().getTotal());
        partitionGroupStat.getDeQueueStat().setTotalSize(partitionGroupStatPo.getDeQueueStat().getTotalSize());
        partitionGroupStat.getReplicationStat().getReplicaStat().setTotal(partitionGroupStatPo.getReplicationStat().getReplicaStat().getTotal());
        partitionGroupStat.getReplicationStat().getReplicaStat().setTotalSize(partitionGroupStatPo.getReplicationStat().getReplicaStat().getTotalSize());
        partitionGroupStat.getReplicationStat().getAppendStat().setTotal(partitionGroupStatPo.getReplicationStat().getAppendStat().getTotal());
        partitionGroupStat.getReplicationStat().getAppendStat().setTotalSize(partitionGroupStatPo.getReplicationStat().getAppendStat().getTotalSize());
        for (Map.Entry<Short, PartitionStatPo> partitionStatPoEntry : partitionGroupStatPo.getPartitionStatMap().entrySet()) {
            PartitionStatPo partitionStatPo = partitionStatPoEntry.getValue();
            PartitionStat partitionStat = partitionGroupStat.getOrCreatePartitionStat(partitionStatPo.getPartition());
            partitionStat.getEnQueueStat().setTotal(partitionStatPo.getEnQueueStat().getTotal());
            partitionStat.getEnQueueStat().setTotalSize(partitionStatPo.getEnQueueStat().getTotalSize());
            partitionStat.getDeQueueStat().setTotal(partitionStatPo.getDeQueueStat().getTotal());
            partitionStat.getDeQueueStat().setTotalSize(partitionStatPo.getDeQueueStat().getTotalSize());
        }
        return partitionGroupStat;
    }
}

