/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.converter;

import com.codahale.metrics.Snapshot;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.monitor.PendingStat;
import org.joyqueue.broker.monitor.converter.Converter;
import org.joyqueue.broker.monitor.stat.AppStat;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.broker.monitor.stat.BrokerStatExt;
import org.joyqueue.broker.monitor.stat.ConsumerPendingStat;
import org.joyqueue.broker.monitor.stat.DeQueueStat;
import org.joyqueue.broker.monitor.stat.EnQueueStat;
import org.joyqueue.broker.monitor.stat.JVMStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupPendingStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.PartitionStat;
import org.joyqueue.broker.monitor.stat.TopicPendingStat;
import org.joyqueue.broker.monitor.stat.TopicStat;
import org.joyqueue.model.MonitorRecord;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.time.SystemClock;
import org.joyqueue.toolkit.vm.MemoryStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConverter
implements Converter<BrokerStatExt, List<MonitorRecord>> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultConverter.class);
    private static final String BROKER_SLICE_HEAP = "broker_slice_heap";
    private static final String BROKER_SLICE_HEAP_INIT = "broker_slice_heap_init";
    private static final String BROKER_SLICE_HEAP_USED = "broker_slice_heap_used";
    private static final String BROKER_SLICE_HEAP_COMMITTED = "broker_slice_heap_committed";
    private static final String BROKER_SLICE_HEAP_MAX = "broker_slice_heap_max";
    private static final String BROKER_SLICE_NON_HEAP = "broker_slice_non_heap";
    private static final String BROKER_SLICE_NON_HEAP_INIT = "broker_slice_non_heap_init";
    private static final String BROKER_SLICE_NON_HEAP_USED = "broker_slice_non_heap_used";
    private static final String BROKER_SLICE_NON_HEAP_COMMITTED = "broker_slice_non_heap_committed";
    private static final String BROKER_SLICE_NON_HEAP_MAX = "broker_slice_non_heap_max";
    private static final String BROKER_SLICE_YOUNG_GC_TIMES = "broker_slice_young_gc_times";
    private static final String BROKER_SLICE_YOUNG_GC_ELAPSED = "broker_slice_young_gc_elapsed";
    private static final String BROKER_SLICE_OLD_GC_TIMES = "broker_slice_old_gc_times";
    private static final String BROKER_SLICE_OLD_GC_ELAPSED = "broker_slice_old_gc_elapsed";
    private static final String BROKER_SLICE_DIRECT_BUFFER_SIZE = "broker_slice_direct_buffer_size";
    private static final String BROKER_SLICE_STORAGE = "broker_slice_storage";
    private static final String BROKER_SLICE_ENQUEUE = "broker_slice_enqueue";
    private static final String BROKER_SLICE_ENQUEUE_SIZE = "broker_slice_enqueue_size";
    private static final String BROKER_SLICE_ENQUEUE_TP99 = "broker_slice_enqueue_tp99";
    private static final String BROKER_SLICE_ENQUEUE_TP90 = "broker_slice_enqueue_tp90";
    private static final String BROKER_SLICE_DEQUEUE = "broker_slice_dequeue";
    private static final String BROKER_SLICE_DEQUEUE_SIZE = "broker_slice_dequeue_size";
    private static final String BROKER_SLICE_DEQUEUE_TP90 = "broker_slice_dequeue_tp90";
    private static final String BROKER_CONNECTION = "broker_connection";
    private static final String TOPIC_SLICE_ENQUEUE = "topic_slice_enqueue";
    private static final String TOPIC_SLICE_ENQUEUE_SIZE = "topic_slice_enqueue_size";
    private static final String TOPIC_SLICE_ENQUEUE_TP99 = "topic_slice_enqueue_tp99";
    private static final String TOPIC_SLICE_ENQUEUE_TP90 = "topic_slice_enqueue_tp90";
    private static final String TOPIC_SLICE_ENQUEUE_MAX = "topic_slice_enqueue_max";
    private static final String TOPIC_SLICE_ENQUEUE_MIN = "topic_slice_enqueue_min";
    private static final String TOPIC_SLICE_ENQUEUE_AVG = "topic_slice_enqueue_avg";
    private static final String TOPIC_SLICE_DEQUEUE = "topic_slice_dequeue";
    private static final String TOPIC_SLICE_DEQUEUE_SIZE = "topic_slice_dequeue_size";
    private static final String TOPIC_SLICE_DEQUEUE_TP99 = "topic_slice_dequeue_tp99";
    private static final String TOPIC_SLICE_DEQUEUE_TP90 = "topic_slice_dequeue_tp90";
    private static final String TOPIC_SLICE_DEQUEUE_MAX = "topic_slice_dequeue_max";
    private static final String TOPIC_SLICE_DEQUEUE_MIN = "topic_slice_dequeue_min";
    private static final String TOPIC_SLICE_DEQUEUE_AVG = "topic_slice_dequeue_avg";
    private static final String TOPIC_SLICE_STORAGE_SIZE = "topic_slice_storage_size";
    private static final String APP_SLICE_DEQUEUE = "app_slice_dequeue";
    private static final String APP_SLICE_DEQUEUE_SIZE = "app_slice_dequeue_size";
    private static final String APP_SLICE_DEQUEUE_CONNECTION = "app_slice_dequeue_connection";
    private static final String APP_SLICE_DEQUEUE_TP99 = "app_slice_dequeue_tp99";
    private static final String APP_SLICE_DEQUEUE_TP90 = "app_slice_dequeue_tp90";
    private static final String APP_SLICE_DEQUEUE_MAX = "app_slice_dequeue_max";
    private static final String APP_SLICE_DEQUEUE_MIN = "app_slice_dequeue_min";
    private static final String APP_SLICE_DEQUEUE_AVG = "app_slice_dequeue_avg";
    private static final String APP_SLICE_ENQUEUE = "app_slice_enqueue";
    private static final String APP_SLICE_ENQUEUE_CONNECTION = "app_slice_enqueue_connection";
    private static final String APP_SLICE_ENQUEUE_SIZE = "app_slice_enqueue_size";
    private static final String APP_SLICE_ENQUEUE_TP99 = "app_slice_enqueue_tp99";
    private static final String APP_SLICE_ENQUEUE_TP90 = "app_slice_enqueue_tp90";
    private static final String APP_SLICE_ENQUEUE_MAX = "app_slice_enqueue_max";
    private static final String APP_SLICE_ENQUEUE_MIN = "app_slice_enqueue_min";
    private static final String APP_SLICE_ENQUEUE_AVG = "app_slice_enqueue_avg";
    private static final String PG_SLICE_DEQUEUE = "pg_slice_dequeue";
    private static final String PG_SLICE_DEQUEUE_SIZE = "pg_slice_dequeue_size";
    private static final String PG_SLICE_DEQUEUE_TP99 = "pg_slice_dequeue_tp99";
    private static final String PG_SLICE_DEQUEUE_TP90 = "pg_slice_dequeue_tp90";
    private static final String PG_SLICE_DEQUEUE_MAX = "pg_slice_dequeue_max";
    private static final String PG_SLICE_DEQUEUE_MIN = "pg_slice_dequeue_min";
    private static final String PG_SLICE_DEQUEUE_AVG = "pg_slice_dequeue_avg";
    private static final String PG_REPLICATE = "pg_replicate";
    private static final String PG_REPLICATE_TP99 = "pg_replicate_tp99";
    private static final String PG_REPLICATE_TP90 = "pg_replicate_tp90";
    private static final String PG_REPLICATE_MAX = "pg_replicate_max";
    private static final String PG_REPLICATE_AVG = "pg_replicate_avg";
    private static final String PG_RECEIVE = "pg_receive";
    private static final String PG_RECEIVE_TP99 = "pg_receive_tp99";
    private static final String PG_RECEIVE_TP90 = "pg_receive_tp90";
    private static final String PG_RECEIVE_MAX = "pg_receive_max";
    private static final String PG_RECEIVE_AVG = "pg_receive_avg";
    private static final String PG_SLICE_ENQUEUE = "pg_slice_enqueue";
    private static final String PG_SLICE_ENQUEUE_SIZE = "pg_slice_enqueue_size";
    private static final String PG_SLICE_ENQUEUE_TP99 = "pg_slice_enqueue_tp99";
    private static final String PG_SLICE_ENQUEUE_TP90 = "pg_slice_enqueue_tp90";
    private static final String PG_SLICE_ENQUEUE_MAX = "pg_slice_enqueue_max";
    private static final String PG_SLICE_ENQUEUE_MIN = "pg_slice_enqueue_min";
    private static final String PG_SLICE_ENQUEUE_AVG = "pg_slice_enqueue_avg";
    private static final String PG_SLICE_REPLICA = "pg_slice_replica";
    private static final String PG_SLICE_REPLICA_LOG_MAX_POSITION = "pg_slice_replica_log_max_position";
    private static final String PG_SLICE_REPLICA_STAT = "pg_slice_replica_state";
    private static final String PG_SLICE_ELECTION = "pg_slice_election";
    private static final String PG_SLICE_ELECTION_TERM = "pg_slice_election_term";
    private static final String PG_SLICE_ELECTION_TYPE = "pg_slice_election_type";
    private static final String TOPIC_PENDING = "topic_pending";
    private static final String APP_PENDING = "app_pending";
    private static final String PG_PENDING = "pg_pending";
    private static final String PARTITION_PENDING = "partition_pending";
    private static final String PARTITION_RIGHT = "partition_right";
    private static final String PARTITION_ACK_INDEX = "partition_ack_index";
    private static final String PRODUCE_ARCHIVE_PENDING = "produce_archive_pending";
    private static final String CONSUME_ARCHIVE_PENDING = "consume_archive_pending";
    private static final String TOPIC_PRODUCE_ARCHIVE_PENDING = "topic_produce_archive_pending";
    private boolean broker = true;
    private boolean topic = true;
    private boolean app = true;
    private boolean partitionGroup = true;
    private boolean pending = true;
    private boolean replicate = true;
    private boolean receive = true;
    private boolean archive = true;
    private boolean partitionStat = true;

    @Override
    public List<MonitorRecord> convert(BrokerStatExt brokerStatExt) {
        BrokerStat brokerStat = brokerStatExt.getBrokerStat();
        String brokerId = "";
        if (brokerStatExt.getBrokerId() != null) {
            brokerId = brokerStatExt.getBrokerId().toString();
        }
        Map<String, TopicPendingStat> topicPending = brokerStatExt.getTopicPendingStatMap();
        ArrayList<MonitorRecord> result = new ArrayList<MonitorRecord>();
        long time = brokerStatExt.getTimeStamp();
        if (time <= 0L) {
            time = SystemClock.now() / 1000L;
        }
        if (this.broker) {
            result.addAll(this.buildBrokerRecord(brokerStat, brokerId, time));
        }
        if (this.topic) {
            result.addAll(this.buildTopicRecord(brokerStat, brokerId, time));
        }
        if (this.app) {
            result.addAll(this.buildBrokerTopicApp(brokerStat, brokerId, time));
        }
        if (this.partitionGroup) {
            result.addAll(this.buildPartitionGroup(brokerStat, brokerId, time));
        }
        if (this.pending) {
            result.addAll(this.buildPending(brokerId, time, topicPending));
        }
        if (this.partitionStat) {
            result.addAll(this.buildPartitionRecord(brokerId, time, topicPending));
        }
        if (this.replicate) {
            result.addAll(this.buildReplicate(brokerId, time, brokerStat));
        }
        if (this.receive) {
            result.addAll(this.buildReceive(brokerId, time, brokerStat));
        }
        if (this.archive) {
            result.addAll(this.buildArchive(brokerId, time, brokerStatExt));
        }
        return result;
    }

    private Collection<? extends MonitorRecord> buildPartitionRecord(String brokerId, long time, Map<String, TopicPendingStat> topicPending) {
        ArrayList<MonitorRecord> records = new ArrayList<MonitorRecord>();
        for (String topic : topicPending.keySet()) {
            TopicPendingStat tps = topicPending.get(topic);
            Map<String, ConsumerPendingStat> appMap = tps.getPendingStatSubMap();
            for (String app : appMap.keySet()) {
                ConsumerPendingStat pendingStat = appMap.get(app);
                Map<Integer, PartitionGroupPendingStat> pgStatMap = pendingStat.getPendingStatSubMap();
                for (Integer pg : pgStatMap.keySet()) {
                    PartitionGroupPendingStat pgStat = pgStatMap.get(pg);
                    Map<Short, PartitionStat> partitionMap = pgStat.getPartitionStatHashMap();
                    for (Short partition : partitionMap.keySet()) {
                        MonitorRecord record = this.getPartitionRecord(brokerId, time, topic, app, pg, partition);
                        record.setValue((double)partitionMap.get(partition).getAckIndex());
                        record.setMetric(PARTITION_ACK_INDEX);
                        this.fillRecord(record, time);
                        records.add(record);
                        record = this.getPartitionRecord(brokerId, time, topic, app, pg, partition);
                        this.fillRecord(record, time);
                        record.setMetric(PARTITION_RIGHT);
                        record.setValue((double)partitionMap.get(partition).getRight());
                        records.add(record);
                    }
                }
            }
        }
        return records;
    }

    private MonitorRecord getPartitionRecord(String brokerId, long time, String topic, String app, Integer pg, Short partition) {
        MonitorRecord record = new MonitorRecord();
        record.topic(topic);
        record.app(app);
        record.partitionGroup(pg + "");
        record.partition(partition + "");
        record.setTimestamp(time);
        record.brokerId(brokerId);
        return record;
    }

    private List<MonitorRecord> buildArchive(String brokerId, long time, BrokerStatExt brokerStat) {
        ArrayList<MonitorRecord> records = new ArrayList<MonitorRecord>();
        String ip = IpUtil.getLocalIp();
        try {
            records.add(this.buildMonitorRecord(CONSUME_ARCHIVE_PENDING, "", "", brokerStat.getArchiveConsumePending(), brokerId, time, ip));
            if (logger.isDebugEnabled()) {
                logger.debug("Archive CONSUME_ARCHIVE_PENDING");
            }
        }
        catch (Exception e) {
            logger.error("Archive build CONSUME_ARCHIVE_PENDING error!", (Throwable)e);
        }
        try {
            records.add(this.buildMonitorRecord(PRODUCE_ARCHIVE_PENDING, "", "", brokerStat.getArchiveProducePending(), brokerId, time, ip));
            if (logger.isDebugEnabled()) {
                logger.debug("Archive PRODUCE_ARCHIVE_PENDING");
            }
        }
        catch (Exception e) {
            logger.error("Archive build PRODUCE_ARCHIVE_PENDING error!", (Throwable)e);
        }
        try {
            Map<String, Long> topicArchivePending = brokerStat.getTopicArchiveProducePending();
            for (String topic : topicArchivePending.keySet()) {
                records.add(this.buildMonitorRecord(TOPIC_PRODUCE_ARCHIVE_PENDING, topic, "", topicArchivePending.get(topic), brokerId, time, ip));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Archive total size {}", (Object)records.size());
            }
        }
        catch (Exception e) {
            logger.error("Archive buildMonitorRecord error!", (Throwable)e);
        }
        return records;
    }

    private MonitorRecord buildMonitorRecord(String metric, String topic, String app, long value, String brokerId, long time, String ip) {
        MonitorRecord mr = new MonitorRecord();
        mr.setMetric(metric);
        mr.host(ip);
        mr.setValue((double)value);
        mr.setTimestamp(time);
        mr.brokerId(brokerId);
        mr.topic(topic);
        mr.app(app);
        return mr;
    }

    private List<MonitorRecord> buildReceive(String brokerId, long time, BrokerStat brokerStat) {
        ArrayList<MonitorRecord> result = new ArrayList<MonitorRecord>();
        ConcurrentMap<String, TopicStat> repStats = brokerStat.getTopicStats();
        for (String topic : repStats.keySet()) {
            ConcurrentMap<Integer, PartitionGroupStat> pgStats = ((TopicStat)repStats.get(topic)).getPartitionGroupStatMap();
            for (Integer pg : pgStats.keySet()) {
                result.addAll(this.buildReceiveRecord(topic, pg, (PartitionGroupStat)pgStats.get(pg), brokerId, time));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Receive size : {}", (Object)result.size());
        }
        return result;
    }

    private List<MonitorRecord> buildReceiveRecord(String topic, Integer pg, PartitionGroupStat partitionGroupStat, String brokerId, long time) {
        MonitorRecord receive;
        MonitorRecord receiveMax;
        MonitorRecord receiveTP90;
        MonitorRecord receiveTP99;
        ArrayList<MonitorRecord> result = new ArrayList<MonitorRecord>();
        MonitorRecord receiveAvg = new MonitorRecord();
        this.fillRecord(receiveAvg, time);
        receiveAvg.brokerId(brokerId);
        receiveAvg.topic(topic);
        receiveAvg.partitionGroup(pg.toString());
        try {
            receiveTP99 = (MonitorRecord)receiveAvg.clone();
            receiveTP90 = (MonitorRecord)receiveAvg.clone();
            receiveMax = (MonitorRecord)receiveAvg.clone();
            receive = (MonitorRecord)receiveAvg.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error("build Receive monitor data error!", (Throwable)e);
            return result;
        }
        EnQueueStat repStat = partitionGroupStat.getReplicationStat().getAppendStat();
        receiveAvg.setMetric(PG_RECEIVE_AVG);
        receiveAvg.setValue(repStat.getAvg());
        receiveTP99.setMetric(PG_RECEIVE_TP99);
        receiveTP99.setValue(repStat.getTp99());
        receiveTP90.setMetric(PG_RECEIVE_TP90);
        receiveTP90.setValue(repStat.getTp90());
        receiveMax.setMetric(PG_RECEIVE_MAX);
        receiveMax.setValue(repStat.getMax());
        receive.setMetric(PG_RECEIVE);
        receive.setValue((double)repStat.getOneMinuteRate());
        result.add(receiveAvg);
        result.add(receiveTP99);
        result.add(receiveTP90);
        result.add(receiveMax);
        result.add(receive);
        return result;
    }

    private List<MonitorRecord> buildReplicate(String brokerId, long time, BrokerStat brokerStat) {
        ArrayList<MonitorRecord> result = new ArrayList<MonitorRecord>();
        ConcurrentMap<String, TopicStat> repStats = brokerStat.getTopicStats();
        for (String topic : repStats.keySet()) {
            ConcurrentMap<Integer, PartitionGroupStat> pgStats = ((TopicStat)repStats.get(topic)).getPartitionGroupStatMap();
            for (Integer pg : pgStats.keySet()) {
                result.addAll(this.buildRepRecord(topic, pg, (PartitionGroupStat)pgStats.get(pg), brokerId, time));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Replicate size : {}", (Object)result.size());
        }
        return result;
    }

    private List<MonitorRecord> buildRepRecord(String topic, Integer pg, PartitionGroupStat partitionGroupStat, String brokerId, long time) {
        MonitorRecord replicate;
        MonitorRecord replicateMax;
        MonitorRecord replicateTP90;
        MonitorRecord replicateTP99;
        ArrayList<MonitorRecord> result = new ArrayList<MonitorRecord>();
        MonitorRecord replicateAvg = new MonitorRecord();
        this.fillRecord(replicateAvg, time);
        replicateAvg.brokerId(brokerId);
        replicateAvg.topic(topic);
        replicateAvg.partitionGroup(pg.toString());
        try {
            replicateTP99 = (MonitorRecord)replicateAvg.clone();
            replicateTP90 = (MonitorRecord)replicateAvg.clone();
            replicateMax = (MonitorRecord)replicateAvg.clone();
            replicate = (MonitorRecord)replicateAvg.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error("build Rep monitor data error!", (Throwable)e);
            return result;
        }
        EnQueueStat repStat = partitionGroupStat.getReplicationStat().getReplicaStat();
        replicateAvg.setMetric(PG_REPLICATE_AVG);
        replicateAvg.setValue(repStat.getAvg());
        replicateTP99.setMetric(PG_REPLICATE_TP99);
        replicateTP99.setValue(repStat.getTp99());
        replicateTP90.setMetric(PG_REPLICATE_TP90);
        replicateTP90.setValue(repStat.getTp90());
        replicateMax.setMetric(PG_REPLICATE_MAX);
        replicateMax.setValue(repStat.getMax());
        replicate.setMetric(PG_REPLICATE);
        replicate.setValue((double)repStat.getOneMinuteRate());
        result.add(replicateAvg);
        result.add(replicateTP99);
        result.add(replicateTP90);
        result.add(replicateMax);
        result.add(replicate);
        return result;
    }

    private List<MonitorRecord> buildPending(String brokerId, long time, Map topicPending) {
        MonitorRecord record = new MonitorRecord();
        this.fillRecord(record, time);
        record.brokerId(brokerId);
        String[] pendingMetrics = new String[]{TOPIC_PENDING, APP_PENDING, PG_PENDING, PARTITION_PENDING};
        return this.buildLevelPending(record, topicPending, pendingMetrics, 0);
    }

    private List<MonitorRecord> buildLevelPending(MonitorRecord record, Map pendingMap, String[] pendingMetrics, int i) {
        ArrayList<MonitorRecord> result = new ArrayList<MonitorRecord>();
        if (pendingMap == null) {
            return result;
        }
        for (Object key : pendingMap.keySet()) {
            MonitorRecord appPending = this.buildRecord(record, pendingMetrics[i]);
            if (appPending == null) continue;
            appPending.addTag("t" + (i + 3), key.toString());
            Object next = pendingMap.get(key);
            if (next == null || !(next instanceof PendingStat)) {
                appPending.setValue(next == null ? 0.0 : (double)((Long)next).longValue());
                result.add(appPending);
                continue;
            }
            Map aps = ((PendingStat)next).getPendingStatSubMap();
            result.addAll(this.buildLevelPending(appPending, aps, pendingMetrics, i + 1));
            if (aps == null) continue;
            Object value = pendingMap.get(key);
            if (value != null && value instanceof PendingStat) {
                PendingStat stat = (PendingStat)value;
                appPending.setValue((double)stat.getPending());
            } else if (value == null) {
                appPending.setValue(0.0);
            } else {
                appPending.setValue(((Double)value).doubleValue());
            }
            result.add(appPending);
        }
        return result;
    }

    private void fillRecord(MonitorRecord record, long time) {
        record.setService("jmq-broker");
        record.setEndpoint("agent.collect");
        record.setCategory("Other");
        record.setProvider("jmq4");
        record.setTimestamp(time);
    }

    private List<MonitorRecord> buildPartitionGroup(BrokerStat brokerStat, String brokerId, long l) {
        ConcurrentMap<String, TopicStat> topics = brokerStat.getTopicStats();
        ArrayList<MonitorRecord> records = new ArrayList<MonitorRecord>();
        records.addAll(this.buildBrokerJVMState(brokerStat.getJvmStat().getRecentSnapshot(), brokerId, l));
        for (String tsKey : topics.keySet()) {
            ConcurrentMap<String, AppStat> appStats = ((TopicStat)topics.get(tsKey)).getAppStats();
            for (String app : appStats.keySet()) {
                AppStat appStat = (AppStat)appStats.get(app);
                ConcurrentMap<Integer, PartitionGroupStat> pgs = appStat.getPartitionGroupStatMap();
                for (Integer key : pgs.keySet()) {
                    if (((PartitionGroupStat)pgs.get(key)).getEnQueueStat() != null) {
                        records.addAll(this.buildEnQueueRecords(((PartitionGroupStat)pgs.get(key)).getEnQueueStat(), brokerId, l, tsKey, app, key));
                    }
                    if (((PartitionGroupStat)pgs.get(key)).getDeQueueStat() == null) continue;
                    records.addAll(this.buildDeQueueRecords(((PartitionGroupStat)pgs.get(key)).getDeQueueStat(), brokerId, l, tsKey, app, key));
                }
            }
            if (topics.get(tsKey) == null) continue;
            ConcurrentMap<Integer, PartitionGroupStat> partitionGroupStatMap = ((TopicStat)topics.get(tsKey)).getPartitionGroupStatMap();
            for (PartitionGroupStat partitionGroupStat : partitionGroupStatMap.values()) {
                records.addAll(this.buildReplicaLag(partitionGroupStat, brokerId, tsKey, null, partitionGroupStat.getPartitionGroup(), l));
                records.addAll(this.buildElectionAndReplicaState(partitionGroupStat, brokerId, tsKey, null, partitionGroupStat.getPartitionGroup(), l));
            }
        }
        return records;
    }

    public List<MonitorRecord> buildReplicaLag(PartitionGroupStat partitionGroupStat, String brokerId, String topic, String app, Integer partitionGroup, long timestampMs) {
        long maxLogPosition = partitionGroupStat.getReplicationStat().getMaxLogPosition();
        MonitorRecord replicaRecord = new MonitorRecord();
        this.fillRecord(replicaRecord, timestampMs);
        replicaRecord.setValue((double)maxLogPosition);
        replicaRecord.brokerId(brokerId);
        replicaRecord.topic(topic);
        replicaRecord.app(app);
        replicaRecord.setMetric(PG_SLICE_REPLICA_LOG_MAX_POSITION);
        replicaRecord.partitionGroup(partitionGroup.toString());
        return Lists.newArrayList((Object[])new MonitorRecord[]{replicaRecord});
    }

    public List<MonitorRecord> buildElectionAndReplicaState(PartitionGroupStat partitionGroupStat, String brokerId, String topic, String app, Integer partitionGroup, long timestampMs) {
        MonitorRecord electionRecord = new MonitorRecord();
        this.fillRecord(electionRecord, timestampMs);
        electionRecord.brokerId(brokerId);
        electionRecord.brokerId(partitionGroup.toString());
        electionRecord.topic(topic);
        electionRecord.app(app);
        electionRecord.partitionGroup(partitionGroup.toString());
        String[] metrics = new String[]{PG_SLICE_ELECTION_TERM, PG_SLICE_ELECTION_TYPE, PG_SLICE_REPLICA_STAT};
        List<MonitorRecord> electionAndReplicaRecords = this.buildEmptyRecords(electionRecord, metrics);
        if (partitionGroupStat.getReplicationStat().getStat().getState() != null && partitionGroupStat.getElectionEventStat().getState() != null) {
            electionAndReplicaRecords.get(0).setValue((double)partitionGroupStat.getElectionEventStat().getTerm());
            electionAndReplicaRecords.get(1).setValue((double)partitionGroupStat.getElectionEventStat().getState().ordinal());
            electionAndReplicaRecords.get(2).setValue((double)partitionGroupStat.getReplicationStat().getStat().getState().ordinal());
        } else {
            electionAndReplicaRecords.get(0).setValue(0.0);
            electionAndReplicaRecords.get(1).setValue(0.0);
            electionAndReplicaRecords.get(2).setValue(0.0);
        }
        return electionAndReplicaRecords;
    }

    public List<MonitorRecord> buildBrokerJVMState(JVMStat jvmStat, String brokerId, long timestampMs) {
        MonitorRecord jvmRecord = new MonitorRecord();
        this.fillRecord(jvmRecord, timestampMs);
        jvmRecord.brokerId(brokerId);
        String[] jvmMetrics = new String[]{BROKER_SLICE_HEAP_INIT, BROKER_SLICE_HEAP_USED, BROKER_SLICE_HEAP_COMMITTED, BROKER_SLICE_HEAP_MAX, BROKER_SLICE_NON_HEAP_INIT, BROKER_SLICE_NON_HEAP_USED, BROKER_SLICE_NON_HEAP_COMMITTED, BROKER_SLICE_NON_HEAP_MAX, BROKER_SLICE_DIRECT_BUFFER_SIZE, BROKER_SLICE_YOUNG_GC_TIMES, BROKER_SLICE_YOUNG_GC_ELAPSED, BROKER_SLICE_OLD_GC_TIMES, BROKER_SLICE_OLD_GC_ELAPSED};
        List<MonitorRecord> jvmMonitorRecords = this.buildEmptyRecords(jvmRecord, jvmMetrics);
        MemoryStat memoryState = jvmStat.getMemoryStat();
        if (memoryState == null) {
            return Lists.newLinkedList();
        }
        jvmMonitorRecords.get(0).setValue((double)memoryState.getHeapInit());
        jvmMonitorRecords.get(1).setValue((double)memoryState.getHeapUsed());
        jvmMonitorRecords.get(2).setValue((double)memoryState.getHeapCommitted());
        jvmMonitorRecords.get(3).setValue((double)memoryState.getHeapMax());
        jvmMonitorRecords.get(4).setValue((double)memoryState.getNonHeapInit());
        jvmMonitorRecords.get(5).setValue((double)memoryState.getNonHeapUsed());
        jvmMonitorRecords.get(6).setValue((double)memoryState.getNonHeapCommitted());
        jvmMonitorRecords.get(7).setValue((double)memoryState.getNonHeapMax());
        jvmMonitorRecords.get(8).setValue((double)memoryState.getDirectBufferSize());
        jvmMonitorRecords.get(9).setValue((double)jvmStat.getOldGcTimes().getCount());
        Snapshot oldSnapshot = jvmStat.getOldGcTimes().getSnapshot();
        jvmMonitorRecords.get(10).setValue(oldSnapshot.getMean() * (double)oldSnapshot.size());
        Snapshot edenSnapshot = jvmStat.getEdenGcTimes().getSnapshot();
        jvmMonitorRecords.get(11).setValue((double)jvmStat.getEdenGcTimes().getCount());
        jvmMonitorRecords.get(12).setValue(edenSnapshot.getMean() * (double)edenSnapshot.size());
        return jvmMonitorRecords;
    }

    private List<MonitorRecord> buildDeQueueRecords(DeQueueStat deQueueStat, String brokerId, long time, String tsKey, String app, Integer key) {
        MonitorRecord deQueue = new MonitorRecord();
        this.fillRecord(deQueue, time);
        deQueue.brokerId(brokerId);
        deQueue.topic(tsKey);
        deQueue.app(app);
        deQueue.partitionGroup(key.toString());
        String[] metrics = new String[]{PG_SLICE_DEQUEUE, PG_SLICE_DEQUEUE_SIZE, PG_SLICE_DEQUEUE_MAX, PG_SLICE_DEQUEUE_AVG, PG_SLICE_DEQUEUE_MIN, PG_SLICE_DEQUEUE_TP99, PG_SLICE_DEQUEUE_TP90};
        List<MonitorRecord> deQueueList = this.buildEmptyRecords(deQueue, metrics);
        deQueueList.get(0).setValue((double)deQueueStat.getOneMinuteRate());
        deQueueList.get(1).setValue((double)deQueueStat.getSize());
        deQueueList.get(2).setValue(deQueueStat.getMax());
        deQueueList.get(3).setValue(deQueueStat.getAvg());
        deQueueList.get(4).setValue(deQueueStat.getMin());
        deQueueList.get(5).setValue(deQueueStat.getTp99());
        deQueueList.get(6).setValue(deQueueStat.getTp90());
        return new ArrayList<MonitorRecord>(deQueueList);
    }

    private List<MonitorRecord> buildEnQueueRecords(EnQueueStat enQueueStat, String brokerId, long time, String tsKey, String app, Integer key) {
        ArrayList<MonitorRecord> records = new ArrayList<MonitorRecord>();
        MonitorRecord enQueue = new MonitorRecord();
        this.fillRecord(enQueue, time);
        enQueue.brokerId(brokerId);
        enQueue.topic(tsKey);
        enQueue.app(app);
        enQueue.partitionGroup(key.toString());
        String[] metrics = new String[]{PG_SLICE_ENQUEUE, PG_SLICE_ENQUEUE_SIZE, PG_SLICE_ENQUEUE_MAX, PG_SLICE_ENQUEUE_AVG, PG_SLICE_ENQUEUE_MIN, PG_SLICE_ENQUEUE_TP99, PG_SLICE_ENQUEUE_TP90};
        List<MonitorRecord> emptyRecords = this.buildEmptyRecords(enQueue, metrics);
        if (emptyRecords.isEmpty()) {
            return records;
        }
        emptyRecords.get(0).setValue((double)enQueueStat.getOneMinuteRate());
        emptyRecords.get(1).setValue((double)enQueueStat.getSize());
        emptyRecords.get(2).setValue(enQueueStat.getMax());
        emptyRecords.get(3).setValue(enQueueStat.getAvg());
        emptyRecords.get(4).setValue(enQueueStat.getMin());
        emptyRecords.get(5).setValue(enQueueStat.getTp99());
        emptyRecords.get(6).setValue(enQueueStat.getTp90());
        records.addAll(emptyRecords);
        return records;
    }

    private List<MonitorRecord> buildBrokerRecord(BrokerStat brokerStat, String brokerId, long time) {
        MonitorRecord connectionsRecord;
        MonitorRecord deQueueTp90;
        MonitorRecord deQueueTp99;
        MonitorRecord enQueueTp90;
        MonitorRecord enQueueTp99;
        MonitorRecord enQueueSize;
        MonitorRecord deQueueSize;
        MonitorRecord deQueueRecord;
        MonitorRecord storage;
        ArrayList<MonitorRecord> records = new ArrayList<MonitorRecord>();
        MonitorRecord enQueue = new MonitorRecord();
        this.fillRecord(enQueue, time);
        enQueue.brokerId(brokerId);
        try {
            storage = (MonitorRecord)enQueue.clone();
            deQueueRecord = (MonitorRecord)enQueue.clone();
            deQueueSize = (MonitorRecord)enQueue.clone();
            enQueueSize = (MonitorRecord)enQueue.clone();
            enQueueTp99 = (MonitorRecord)enQueue.clone();
            enQueueTp90 = (MonitorRecord)enQueue.clone();
            deQueueTp99 = (MonitorRecord)enQueue.clone();
            deQueueTp90 = (MonitorRecord)enQueue.clone();
            connectionsRecord = (MonitorRecord)enQueue.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error("clone monitor record error!", (Throwable)e);
            return records;
        }
        storage.setMetric(BROKER_SLICE_STORAGE);
        storage.setValue((double)brokerStat.getStoragePercent().intValue());
        enQueue.setMetric(BROKER_SLICE_ENQUEUE);
        enQueue.setValue((double)brokerStat.getEnQueueStat().getOneMinuteRate());
        enQueueSize.setMetric(BROKER_SLICE_ENQUEUE_SIZE);
        enQueueSize.setValue((double)brokerStat.getEnQueueStat().getSize());
        deQueueRecord.setMetric(BROKER_SLICE_DEQUEUE);
        deQueueRecord.setValue((double)brokerStat.getDeQueueStat().getOneMinuteRate());
        deQueueSize.setMetric(BROKER_SLICE_DEQUEUE_SIZE);
        deQueueSize.setValue((double)brokerStat.getDeQueueStat().getSize());
        connectionsRecord.setValue((double)brokerStat.getConnectionStat().getConnection());
        connectionsRecord.setMetric(BROKER_CONNECTION);
        enQueueTp99.setMetric(BROKER_SLICE_ENQUEUE_TP99);
        enQueueTp90.setMetric(BROKER_SLICE_ENQUEUE_TP90);
        enQueueTp99.setValue(brokerStat.getEnQueueStat().getTp99());
        enQueueTp90.setValue(brokerStat.getEnQueueStat().getTp90());
        deQueueTp99.setMetric(BROKER_SLICE_ENQUEUE_TP99);
        deQueueTp90.setMetric(BROKER_SLICE_DEQUEUE_TP90);
        deQueueTp99.setValue(brokerStat.getDeQueueStat().getTp99());
        deQueueTp90.setValue(brokerStat.getDeQueueStat().getTp90());
        records.add(storage);
        records.add(deQueueRecord);
        records.add(deQueueSize);
        records.add(enQueue);
        records.add(enQueueSize);
        records.add(enQueueTp99);
        records.add(enQueueTp90);
        records.add(deQueueTp99);
        records.add(deQueueTp90);
        return records;
    }

    private List<MonitorRecord> buildTopicRecord(BrokerStat brokerStat, String brokerId, long time) {
        ArrayList<MonitorRecord> records = new ArrayList<MonitorRecord>();
        ConcurrentMap<String, TopicStat> topics = brokerStat.getTopicStats();
        for (String tsKey : topics.keySet()) {
            String[] topicStorageMetric;
            List<MonitorRecord> topicStorageRecords;
            String[] deQueueMetrics;
            List<MonitorRecord> deQueueRecords;
            MonitorRecord enQueue = new MonitorRecord();
            this.fillRecord(enQueue, time);
            enQueue.brokerId(brokerId);
            enQueue.topic(tsKey);
            String[] enQueueMetrics = new String[]{TOPIC_SLICE_ENQUEUE, TOPIC_SLICE_ENQUEUE_SIZE, TOPIC_SLICE_ENQUEUE_MAX, TOPIC_SLICE_ENQUEUE_AVG, TOPIC_SLICE_ENQUEUE_MIN, TOPIC_SLICE_ENQUEUE_TP99, TOPIC_SLICE_ENQUEUE_TP90};
            List<MonitorRecord> enQueueRecords = this.buildEmptyRecords(enQueue, enQueueMetrics);
            if (enQueueRecords != null && enQueueRecords.size() == enQueueMetrics.length) {
                enQueueRecords.get(0).setValue((double)((TopicStat)topics.get(tsKey)).getEnQueueStat().getOneMinuteRate());
                enQueueRecords.get(1).setValue((double)((TopicStat)topics.get(tsKey)).getEnQueueStat().getSize());
                enQueueRecords.get(2).setValue(((TopicStat)topics.get(tsKey)).getEnQueueStat().getMax());
                enQueueRecords.get(3).setValue(((TopicStat)topics.get(tsKey)).getEnQueueStat().getAvg());
                enQueueRecords.get(4).setValue(((TopicStat)topics.get(tsKey)).getEnQueueStat().getMin());
                enQueueRecords.get(5).setValue(((TopicStat)topics.get(tsKey)).getEnQueueStat().getTp99());
                enQueueRecords.get(6).setValue(((TopicStat)topics.get(tsKey)).getEnQueueStat().getTp90());
                records.addAll(enQueueRecords);
            }
            if ((deQueueRecords = this.buildEmptyRecords(enQueue, deQueueMetrics = new String[]{TOPIC_SLICE_DEQUEUE, TOPIC_SLICE_DEQUEUE_SIZE, TOPIC_SLICE_DEQUEUE_MAX, TOPIC_SLICE_DEQUEUE_AVG, TOPIC_SLICE_DEQUEUE_MIN, TOPIC_SLICE_DEQUEUE_TP99, TOPIC_SLICE_DEQUEUE_TP90})) != null && deQueueRecords.size() == deQueueMetrics.length) {
                deQueueRecords.get(0).setValue((double)((TopicStat)topics.get(tsKey)).getDeQueueStat().getOneMinuteRate());
                deQueueRecords.get(1).setValue((double)((TopicStat)topics.get(tsKey)).getDeQueueStat().getSize());
                deQueueRecords.get(2).setValue(((TopicStat)topics.get(tsKey)).getDeQueueStat().getMax());
                deQueueRecords.get(3).setValue(((TopicStat)topics.get(tsKey)).getDeQueueStat().getAvg());
                deQueueRecords.get(4).setValue(((TopicStat)topics.get(tsKey)).getDeQueueStat().getMin());
                deQueueRecords.get(5).setValue(((TopicStat)topics.get(tsKey)).getDeQueueStat().getTp99());
                deQueueRecords.get(6).setValue(((TopicStat)topics.get(tsKey)).getDeQueueStat().getTp90());
                records.addAll(deQueueRecords);
            }
            if ((topicStorageRecords = this.buildEmptyRecords(enQueue, topicStorageMetric = new String[]{TOPIC_SLICE_STORAGE_SIZE})) == null || topicStorageRecords.size() <= 0) continue;
            topicStorageRecords.get(0).setValue((double)((TopicStat)topics.get(tsKey)).getStoreSize());
            records.addAll(topicStorageRecords);
        }
        return records;
    }

    private List<MonitorRecord> buildBrokerTopicApp(BrokerStat brokerStat, String brokerId, long time) {
        ConcurrentMap<String, TopicStat> topics = brokerStat.getTopicStats();
        logger.debug("start collect app metric ,topicSize: " + topics.size());
        ArrayList<MonitorRecord> records = new ArrayList<MonitorRecord>();
        for (String tsKey : topics.keySet()) {
            ConcurrentMap<String, AppStat> appStats = ((TopicStat)topics.get(tsKey)).getAppStats();
            if (appStats == null || appStats.isEmpty()) {
                logger.debug("appStats is empty!");
            } else {
                logger.debug("appStatus size:" + appStats.size());
            }
            for (String app : appStats.keySet()) {
                AppStat appStat = (AppStat)appStats.get(app);
                if (appStat.getConsumerStat() != null) {
                    records.addAll(this.getConsumerRecord(appStat, tsKey, time, brokerId));
                }
                if (appStat.getProducerStat() == null) continue;
                records.addAll(this.getProducerRecord(appStat, tsKey, time, brokerId));
            }
        }
        logger.debug("All app metrics result :" + records.size());
        return records;
    }

    private List<MonitorRecord> getProducerRecord(AppStat appStat, String topic, long time, String brokerId) {
        String[] metrics;
        List<MonitorRecord> emptyRecords;
        ArrayList<MonitorRecord> records = new ArrayList<MonitorRecord>();
        logger.debug("Start collect producer records!");
        String app = appStat.getApp();
        MonitorRecord enQueue = new MonitorRecord();
        this.fillRecord(enQueue, time);
        enQueue.brokerId(brokerId);
        enQueue.topic(topic);
        enQueue.app(app);
        MonitorRecord connection = this.buildRecord(enQueue, APP_SLICE_ENQUEUE_CONNECTION);
        if (connection != null) {
            connection.setValue((double)appStat.getConnectionStat().getConnection());
            records.add(connection);
        }
        if ((emptyRecords = this.buildEmptyRecords(enQueue, metrics = new String[]{APP_SLICE_ENQUEUE, APP_SLICE_ENQUEUE_SIZE, APP_SLICE_ENQUEUE_MAX, APP_SLICE_ENQUEUE_AVG, APP_SLICE_ENQUEUE_MIN, APP_SLICE_ENQUEUE_TP99, APP_SLICE_ENQUEUE_TP90})) != null && emptyRecords.size() == metrics.length) {
            emptyRecords.get(0).setValue((double)appStat.getProducerStat().getEnQueueStat().getOneMinuteRate());
            emptyRecords.get(1).setValue((double)appStat.getProducerStat().getEnQueueStat().getSize());
            emptyRecords.get(2).setValue(appStat.getProducerStat().getEnQueueStat().getMax());
            emptyRecords.get(3).setValue(appStat.getProducerStat().getEnQueueStat().getAvg());
            emptyRecords.get(4).setValue(appStat.getProducerStat().getEnQueueStat().getMin());
            emptyRecords.get(5).setValue(appStat.getProducerStat().getEnQueueStat().getTp99());
            emptyRecords.get(6).setValue(appStat.getProducerStat().getEnQueueStat().getTp90());
            records.addAll(emptyRecords);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Producer records:" + records.size());
        }
        return records;
    }

    private MonitorRecord buildRecord(MonitorRecord enQueue, String appSliceEnqueueConnection) {
        try {
            MonitorRecord result = (MonitorRecord)enQueue.clone();
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : enQueue.getTags().keySet()) {
                map.put(key, enQueue.getTag(key));
            }
            result.setTags(map);
            result.setMetric(appSliceEnqueueConnection);
            return result;
        }
        catch (CloneNotSupportedException e) {
            logger.error("Clone MonitorRecord error!", (Throwable)e);
            return null;
        }
    }

    private List<MonitorRecord> buildEmptyRecords(MonitorRecord count, String[] metrics) {
        ArrayList<MonitorRecord> result = new ArrayList<MonitorRecord>();
        for (String metric : metrics) {
            try {
                MonitorRecord record = (MonitorRecord)count.clone();
                record.setMetric(metric);
                result.add(record);
            }
            catch (CloneNotSupportedException e) {
                logger.error("clone monitor record error!", (Throwable)e);
            }
        }
        if (result.size() != metrics.length) {
            result.clear();
        }
        return result;
    }

    private List<MonitorRecord> getConsumerRecord(AppStat appStat, String topic, long time, String brokerId) {
        String[] metrics;
        List<MonitorRecord> emptyRecords;
        ArrayList<MonitorRecord> records = new ArrayList<MonitorRecord>();
        if (logger.isDebugEnabled()) {
            logger.debug("Start collect consume records!");
        }
        String app = appStat.getApp();
        MonitorRecord deQueue = new MonitorRecord();
        this.fillRecord(deQueue, time);
        deQueue.brokerId(brokerId);
        deQueue.topic(topic);
        deQueue.app(app);
        MonitorRecord connection = this.buildRecord(deQueue, APP_SLICE_DEQUEUE_CONNECTION);
        if (connection != null) {
            connection.setValue((double)appStat.getConsumerStat().getConnectionStat().getConnection());
            records.add(connection);
        }
        if ((emptyRecords = this.buildEmptyRecords(deQueue, metrics = new String[]{APP_SLICE_DEQUEUE, APP_SLICE_DEQUEUE_SIZE, APP_SLICE_DEQUEUE_MAX, APP_SLICE_DEQUEUE_AVG, APP_SLICE_DEQUEUE_MIN, APP_SLICE_DEQUEUE_TP99, APP_SLICE_DEQUEUE_TP90})) != null && emptyRecords.size() == 7) {
            emptyRecords.get(0).setValue((double)appStat.getConsumerStat().getDeQueueStat().getOneMinuteRate());
            emptyRecords.get(1).setValue((double)appStat.getConsumerStat().getDeQueueStat().getSize());
            emptyRecords.get(2).setValue(appStat.getConsumerStat().getDeQueueStat().getMax());
            emptyRecords.get(3).setValue(appStat.getConsumerStat().getDeQueueStat().getAvg());
            emptyRecords.get(4).setValue(appStat.getConsumerStat().getDeQueueStat().getMin());
            emptyRecords.get(5).setValue(appStat.getConsumerStat().getDeQueueStat().getTp99());
            emptyRecords.get(6).setValue(appStat.getConsumerStat().getDeQueueStat().getTp90());
            records.addAll(emptyRecords);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("consume records:" + records.size());
        }
        return records;
    }

    public String type() {
        return "default";
    }
}

