/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.metrics;

import com.alibaba.fastjson.annotation.JSONField;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.Snapshot;

public class LoadMetric
implements Metered,
Sampling {
    private Meter meter;
    private Histogram histogram;

    public LoadMetric() {
        this.reset();
    }

    public LoadMetric(Meter meter, Histogram histogram) {
        this.meter = meter;
        this.histogram = histogram;
    }

    @JSONField(serialize=false)
    public LoadMetric getIntervalLoadMetric() {
        LoadMetric snapshot = new LoadMetric(this.meter, this.histogram);
        this.reset();
        return snapshot;
    }

    public void mark(long count) {
        this.meter.mark(count);
    }

    public void mark(double time, long count) {
        this.meter.mark(count);
        this.histogram.update((long)time);
    }

    private void reset() {
        this.meter = new Meter();
        this.histogram = new Histogram((Reservoir)new ExponentiallyDecayingReservoir());
    }

    public long getCount() {
        return this.meter.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.meter.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.meter.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.meter.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.meter.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.histogram.getSnapshot();
    }
}

