/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.service.support;

import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.management.NotificationListener;
import org.joyqueue.broker.archive.ArchiveManager;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.monitor.converter.BrokerMonitorConverter;
import org.joyqueue.broker.monitor.service.BrokerMonitorInternalService;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.broker.monitor.stat.BrokerStatExt;
import org.joyqueue.broker.monitor.stat.ConsumerPendingStat;
import org.joyqueue.broker.monitor.stat.JVMStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupPendingStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.PartitionStat;
import org.joyqueue.broker.monitor.stat.TopicPendingStat;
import org.joyqueue.broker.monitor.stat.TopicStat;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.monitor.BrokerMonitorInfo;
import org.joyqueue.monitor.BrokerStartupInfo;
import org.joyqueue.monitor.ElectionMonitorInfo;
import org.joyqueue.monitor.NameServerMonitorInfo;
import org.joyqueue.monitor.StoreMonitorInfo;
import org.joyqueue.nsr.NameService;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.StoreManagementService;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.format.Format;
import org.joyqueue.toolkit.lang.Online;
import org.joyqueue.toolkit.vm.DefaultGCNotificationParser;
import org.joyqueue.toolkit.vm.GCEvent;
import org.joyqueue.toolkit.vm.GCEventListener;
import org.joyqueue.toolkit.vm.GCEventType;
import org.joyqueue.toolkit.vm.GarbageCollectorMonitor;
import org.joyqueue.toolkit.vm.JVMMonitorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBrokerMonitorInternalService
implements BrokerMonitorInternalService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBrokerMonitorInternalService.class);
    private BrokerStat brokerStat;
    private Consume consume;
    private StoreManagementService storeManagementService;
    private NameService nameService;
    private StoreService storeService;
    private ElectionService electionService;
    private ClusterManager clusterManager;
    private BrokerStartupInfo brokerStartupInfo;
    private JVMMonitorService jvmMonitorService;
    private ArchiveManager archiveManager;
    private DefaultGCNotificationParser gcNotificationParser;

    public DefaultBrokerMonitorInternalService(BrokerStat brokerStat, Consume consume, StoreManagementService storeManagementService, NameService nameService, StoreService storeService, ElectionService electionManager, ClusterManager clusterManager, BrokerStartupInfo brokerStartupInfo, ArchiveManager archiveManager) {
        this.brokerStat = brokerStat;
        this.consume = consume;
        this.storeManagementService = storeManagementService;
        this.nameService = nameService;
        this.storeService = storeService;
        this.electionService = electionManager;
        this.clusterManager = clusterManager;
        this.brokerStartupInfo = brokerStartupInfo;
        this.jvmMonitorService = new GarbageCollectorMonitor();
        this.gcNotificationParser = new DefaultGCNotificationParser();
        this.gcNotificationParser.addListener((GCEventListener)new DefaultGCEventListener(brokerStat.getJvmStat()));
        this.jvmMonitorService.addGCEventListener((NotificationListener)this.gcNotificationParser);
        this.archiveManager = archiveManager;
    }

    @Override
    public BrokerMonitorInfo getBrokerInfo() {
        BrokerMonitorInfo brokerMonitorInfo = new BrokerMonitorInfo();
        brokerMonitorInfo.setConnection(BrokerMonitorConverter.convertConnectionMonitorInfo(this.brokerStat.getConnectionStat()));
        brokerMonitorInfo.setEnQueue(BrokerMonitorConverter.convertEnQueueMonitorInfo(this.brokerStat.getEnQueueStat()));
        brokerMonitorInfo.setDeQueue(BrokerMonitorConverter.convertDeQueueMonitorInfo(this.brokerStat.getDeQueueStat()));
        brokerMonitorInfo.setReplication(BrokerMonitorConverter.convertReplicationMonitorInfo(this.brokerStat.getReplicationStat()));
        StoreMonitorInfo storeMonitorInfo = new StoreMonitorInfo();
        storeMonitorInfo.setStarted(this.storeService instanceof Online ? ((Online)this.storeService).isStarted() : true);
        storeMonitorInfo.setFreeSpace(Format.formatSize((long)this.storeManagementService.freeSpace()));
        storeMonitorInfo.setTotalSpace(Format.formatSize((long)this.storeManagementService.totalSpace()));
        NameServerMonitorInfo nameServerMonitorInfo = new NameServerMonitorInfo();
        nameServerMonitorInfo.setStarted(this.nameService.isStarted());
        ElectionMonitorInfo electionMonitorInfo = new ElectionMonitorInfo();
        boolean electionStarted = this.electionService instanceof Online ? ((Online)this.electionService).isStarted() : true;
        electionMonitorInfo.setStarted(electionStarted);
        brokerMonitorInfo.getReplication().setStarted(electionStarted);
        brokerMonitorInfo.setStore(storeMonitorInfo);
        brokerMonitorInfo.setNameServer(nameServerMonitorInfo);
        brokerMonitorInfo.setElection(electionMonitorInfo);
        brokerMonitorInfo.setBufferPoolMonitorInfo(this.storeService.monitorInfo());
        brokerMonitorInfo.setStartupInfo(this.brokerStartupInfo);
        return brokerMonitorInfo;
    }

    @Override
    public BrokerStatExt getExtendBrokerStat(long timeStamp) {
        BrokerStatExt statExt = new BrokerStatExt(this.brokerStat);
        statExt.setTimeStamp(timeStamp);
        this.getJVMState();
        statExt.getBrokerStat().getJvmStat().getRecentSnapshot();
        statExt.setTimeStamp(timeStamp);
        this.brokerStat.getJvmStat().setMemoryStat(this.jvmMonitorService.memSnapshot());
        Map<String, TopicPendingStat> topicPendingStatMap = statExt.getTopicPendingStatMap();
        for (TopicConfig topic : this.clusterManager.getTopics()) {
            TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic.getName().getFullName());
            TopicPendingStat topicPendingStat = new TopicPendingStat();
            topicPendingStat.setTopic(topic.getName().getFullName());
            topicPendingStatMap.put(topic.getName().getFullName(), topicPendingStat);
            long storageSize = 0L;
            List partitionGroupStores = this.storeService.getStore(topicStat.getTopic());
            for (PartitionGroupStore pgStore : partitionGroupStores) {
                storageSize += pgStore.getTotalPhysicalStorageSize();
            }
            topicStat.setStoreSize(storageSize);
            long topicPending = 0L;
            List<Consumer> consumers = this.clusterManager.getLocalConsumersByTopic(topic.getName());
            for (Consumer consumer : consumers) {
                long consumerPending = 0L;
                ConsumerPendingStat consumerPendingStat = new ConsumerPendingStat();
                consumerPendingStat.setApp(consumer.getApp());
                consumerPendingStat.setTopic(consumer.getTopic().getFullName());
                Map<String, ConsumerPendingStat> consumerPendingStatMap = topicPendingStat.getPendingStatSubMap();
                consumerPendingStatMap.put(consumer.getApp(), consumerPendingStat);
                Map<Integer, PartitionGroupPendingStat> partitionGroupPendingStatMap = consumerPendingStat.getPendingStatSubMap();
                StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(consumer.getTopic().getFullName());
                for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
                    if (!this.clusterManager.isLeader(consumer.getTopic().getFullName(), partitionGroupMetric.getPartitionGroup())) continue;
                    long partitionGroupPending = 0L;
                    int partitionGroupId = partitionGroupMetric.getPartitionGroup();
                    PartitionGroupPendingStat partitionGroupPendingStat = new PartitionGroupPendingStat();
                    partitionGroupPendingStat.setPartitionGroup(partitionGroupId);
                    partitionGroupPendingStat.setTopic(consumer.getTopic().getFullName());
                    partitionGroupPendingStat.setApp(consumer.getApp());
                    partitionGroupPendingStatMap.put(partitionGroupId, partitionGroupPendingStat);
                    for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                        long ackIndex = this.consume.getAckIndex(new org.joyqueue.network.session.Consumer(consumer.getTopic().getFullName(), consumer.getApp()), partitionMetric.getPartition());
                        if (ackIndex < 0L) {
                            ackIndex = 0L;
                        }
                        long partitionPending = partitionMetric.getRightIndex() - ackIndex;
                        Map<Short, Long> partitionPendStatMap = partitionGroupPendingStat.getPendingStatSubMap();
                        PartitionStat stat = new PartitionStat(consumer.getTopic().getFullName(), consumer.getApp(), partitionMetric.getPartition());
                        stat.setAckIndex(ackIndex);
                        stat.setRight(partitionMetric.getRightIndex());
                        partitionGroupPendingStat.getPartitionStatHashMap().put(partitionMetric.getPartition(), stat);
                        partitionPendStatMap.put(partitionMetric.getPartition(), partitionPending);
                        partitionGroupPending += partitionPending;
                    }
                    partitionGroupPendingStat.setPending(partitionGroupPending);
                    consumerPending += partitionGroupPending;
                }
                consumerPendingStat.setPending(consumerPending);
                topicPending += consumerPending;
            }
            topicPendingStat.setPending(topicPending);
        }
        this.snapshotReplicaLag();
        this.runtimeMemoryUsageState(statExt);
        this.runtimeStorageOccupy(this.brokerStat);
        statExt.setArchiveConsumePending(this.archiveManager.getConsumeBacklogNum());
        statExt.setArchiveProducePending(this.archiveManager.getSendBacklogNum());
        statExt.setTopicArchiveProducePending(this.archiveManager.getSendBacklogNumByTopic());
        return statExt;
    }

    public void snapshotReplicaLag() {
        ConcurrentMap<String, TopicStat> topicStatMap = this.brokerStat.getTopicStats();
        for (TopicStat topicStat : topicStatMap.values()) {
            ConcurrentMap<Integer, PartitionGroupStat> partitionGroupStatMap = topicStat.getPartitionGroupStatMap();
            for (PartitionGroupStat partitionGroupStat : partitionGroupStatMap.values()) {
                StoreManagementService.PartitionGroupMetric partitionGroupMetric = this.storeManagementService.partitionGroupMetric(partitionGroupStat.getTopic(), partitionGroupStat.getPartitionGroup());
                if (partitionGroupMetric == null) continue;
                partitionGroupStat.getReplicationStat().setMaxLogPosition(partitionGroupMetric.getRightPosition());
            }
        }
    }

    public void runtimeMemoryUsageState(BrokerStatExt brokerStatExt) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        brokerStatExt.setHeap(memoryMXBean.getHeapMemoryUsage());
        brokerStatExt.setNonHeap(memoryMXBean.getNonHeapMemoryUsage());
    }

    @Override
    public JVMStat getJVMState() {
        JVMStat jvmStat = this.brokerStat.getJvmStat();
        jvmStat.setMemoryStat(this.jvmMonitorService.memSnapshot());
        return jvmStat;
    }

    @Override
    public BrokerStartupInfo getStartInfo() {
        return this.brokerStartupInfo;
    }

    @Override
    public void addGcEventListener(GCEventListener listener) {
        this.gcNotificationParser.addListener(listener);
    }

    public void runtimeStorageOccupy(BrokerStat stat) {
        double totalSpace = this.storeManagementService.totalSpace();
        double freeSpace = this.storeManagementService.freeSpace();
        int percentage = (int)((1.0 - freeSpace / totalSpace) * 100.0);
        stat.setStoragePercent(percentage);
    }

    public class DefaultGCEventListener
    implements GCEventListener {
        private JVMStat jvmStat;

        public DefaultGCEventListener(JVMStat jvmStat) {
            this.jvmStat = jvmStat;
        }

        public void handleNotification(GCEvent event) {
            GcInfo gcInfo = event.getGcInfo().getGcInfo();
            if (event.getType() == GCEventType.END_OF_MAJOR || event.getType() == GCEventType.END_OF_MINOR) {
                this.jvmStat.getTotalGcTime().addAndGet(gcInfo.getDuration());
                this.jvmStat.getTotalGcTimes().incrementAndGet();
            }
            if (event.getType() == GCEventType.END_OF_MAJOR) {
                this.jvmStat.getOldGcTimes().mark(gcInfo.getDuration(), 1L);
            } else if (event.getType() == GCEventType.END_OF_MINOR) {
                this.jvmStat.getEdenGcTimes().mark(gcInfo.getDuration(), 1L);
            }
        }
    }
}

