/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.service.support;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.monitor.converter.BrokerMonitorConverter;
import org.joyqueue.broker.monitor.service.ConnectionMonitorService;
import org.joyqueue.broker.monitor.stat.AppStat;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.broker.monitor.stat.ConnectionStat;
import org.joyqueue.broker.monitor.stat.TopicStat;
import org.joyqueue.monitor.Client;
import org.joyqueue.monitor.ConnectionMonitorDetailInfo;
import org.joyqueue.monitor.ConnectionMonitorInfo;

public class DefaultConnectionMonitorService
implements ConnectionMonitorService {
    private BrokerStat brokerStat;

    public DefaultConnectionMonitorService(BrokerStat brokerStat) {
        this.brokerStat = brokerStat;
    }

    @Override
    public ConnectionMonitorInfo getConnectionInfo() {
        ConnectionStat connectionStat = this.brokerStat.getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorInfo(connectionStat);
    }

    @Override
    public ConnectionMonitorInfo getConnectionInfoByTopic(String topic) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        ConnectionStat connectionStat = topicStat.getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorInfo(connectionStat);
    }

    @Override
    public ConnectionMonitorInfo getConnectionInfoByTopicAndApp(String topic, String app) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        ConnectionStat connectionStat = appStat.getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorInfo(connectionStat);
    }

    @Override
    public ConnectionMonitorDetailInfo getConnectionDetailInfo() {
        ConnectionStat connectionStat = this.brokerStat.getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorDetailInfo(connectionStat);
    }

    @Override
    public ConnectionMonitorDetailInfo getConnectionDetailInfoByTopic(String topic) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        ConnectionStat connectionStat = topicStat.getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorDetailInfo(connectionStat);
    }

    @Override
    public ConnectionMonitorDetailInfo getConnectionDetailInfoByTopicAndApp(String topic, String app) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        AppStat appStat = topicStat.getOrCreateAppStat(app);
        ConnectionStat connectionStat = appStat.getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorDetailInfo(connectionStat);
    }

    @Override
    public ConnectionMonitorDetailInfo getConsumerConnectionDetailInfoByTopic(String topic) {
        ConnectionStat connectionStat = this.brokerStat.getOrCreateTopicStat(topic).getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorDetailInfo(connectionStat, this.filterConsumerClient(connectionStat.getConnectionMap()));
    }

    @Override
    public ConnectionMonitorDetailInfo getConsumerConnectionDetailInfoByTopicAndApp(String topic, String app) {
        ConnectionStat connectionStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app).getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorDetailInfo(connectionStat, this.filterConsumerClient(connectionStat.getConnectionMap()));
    }

    @Override
    public ConnectionMonitorDetailInfo getProducerConnectionDetailInfoByTopic(String topic) {
        ConnectionStat connectionStat = this.brokerStat.getOrCreateTopicStat(topic).getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorDetailInfo(connectionStat, this.filterProducerClient(connectionStat.getConnectionMap()));
    }

    @Override
    public ConnectionMonitorDetailInfo getProducerConnectionDetailInfoByTopicAndApp(String topic, String app) {
        ConnectionStat connectionStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app).getConnectionStat();
        return BrokerMonitorConverter.convertConnectionMonitorDetailInfo(connectionStat, this.filterProducerClient(connectionStat.getConnectionMap()));
    }

    protected List<Client> filterConsumerClient(Map<String, Client> clients) {
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry<String, Client> entry : clients.entrySet()) {
            if (!entry.getValue().isConsumerRole()) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    protected List<Client> filterProducerClient(Map<String, Client> clients) {
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry<String, Client> entry : clients.entrySet()) {
            if (!entry.getValue().isProducerRole()) continue;
            result.add(entry.getValue());
        }
        return result;
    }
}

