/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.service.support;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.coordinator.CoordinatorService;
import org.joyqueue.broker.coordinator.domain.CoordinatorDetail;
import org.joyqueue.broker.coordinator.group.GroupMetadataManager;
import org.joyqueue.broker.coordinator.group.domain.GroupMemberMetadata;
import org.joyqueue.broker.coordinator.group.domain.GroupMetadata;
import org.joyqueue.broker.monitor.service.CoordinatorMonitorService;

public class DefaultCoordinatorMonitorService
implements CoordinatorMonitorService {
    private CoordinatorService coordinatorService;

    public DefaultCoordinatorMonitorService(CoordinatorService coordinatorService) {
        this.coordinatorService = coordinatorService;
    }

    @Override
    public CoordinatorDetail getCoordinator(String groupId) {
        return this.coordinatorService.getCoordinator().getGroupDetail(groupId);
    }

    @Override
    public GroupMetadata getCoordinatorGroup(String namespace, String groupId, String topic, boolean isFormat) {
        GroupMetadataManager groupMetadataManager = this.coordinatorService.getOrCreateGroupMetadataManager(namespace);
        Object group = groupMetadataManager.getGroup(groupId);
        if (group == null) {
            return null;
        }
        if (!isFormat) {
            return group;
        }
        GroupMetadata result = new GroupMetadata();
        result.setId(((GroupMetadata)group).getId());
        result.setExtension(((GroupMetadata)group).getExtension());
        result.setMembers(this.formatCoordinatorGroupMembers((GroupMetadata)group, topic));
        result.setExpiredMembersMap(Maps.newHashMap(((GroupMetadata)group).expiredMembersToMap()));
        return result;
    }

    @Override
    public Map<String, GroupMemberMetadata> getCoordinatorGroupMembers(String namespace, String groupId, String topic, boolean isFormat) {
        GroupMetadataManager groupMetadataManager = this.coordinatorService.getOrCreateGroupMetadataManager(namespace);
        Object group = groupMetadataManager.getGroup(groupId);
        if (group == null) {
            return null;
        }
        if (!isFormat) {
            return ((GroupMetadata)group).getMembers();
        }
        return this.formatCoordinatorGroupMembers((GroupMetadata)group, topic);
    }

    protected ConcurrentMap<String, GroupMemberMetadata> formatCoordinatorGroupMembers(GroupMetadata group, String topic) {
        if (MapUtils.isEmpty(group.getMembers())) {
            return null;
        }
        ConcurrentMap result = Maps.newConcurrentMap();
        for (Map.Entry entry : group.getMembers().entrySet()) {
            GroupMemberMetadata sourceMember = (GroupMemberMetadata)entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)topic) && sourceMember.getAssignments() != null && !sourceMember.getAssignments().containsKey(topic)) continue;
            GroupMemberMetadata member = new GroupMemberMetadata();
            member.setId(sourceMember.getId());
            member.setGroupId(sourceMember.getGroupId());
            member.setConnectionId(sourceMember.getConnectionId());
            member.setConnectionHost(sourceMember.getConnectionHost());
            member.setLatestHeartbeat(sourceMember.getLatestHeartbeat());
            member.setSessionTimeout(sourceMember.getSessionTimeout());
            if (StringUtils.isBlank((CharSequence)topic)) {
                member.setAssignments(sourceMember.getAssignments());
            } else if (MapUtils.isNotEmpty(sourceMember.getAssignments())) {
                member.setAssignmentList(sourceMember.getAssignments().get(topic));
            }
            result.put(entry.getKey(), member);
        }
        return result;
    }
}

