/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.service.support;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jd.laf.extension.ExtensionPoint;
import com.jd.laf.extension.ExtensionPointLazy;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.cluster.ClusterNameService;
import org.joyqueue.broker.config.Configuration;
import org.joyqueue.broker.monitor.service.MetadataMonitorService;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.InternalServiceProvider;
import org.joyqueue.nsr.MetadataSynchronizer;
import org.joyqueue.nsr.service.internal.AppTokenInternalService;
import org.joyqueue.nsr.service.internal.BrokerInternalService;
import org.joyqueue.nsr.service.internal.ClusterInternalService;
import org.joyqueue.nsr.service.internal.ConfigInternalService;
import org.joyqueue.nsr.service.internal.ConsumerInternalService;
import org.joyqueue.nsr.service.internal.DataCenterInternalService;
import org.joyqueue.nsr.service.internal.NamespaceInternalService;
import org.joyqueue.nsr.service.internal.OperationInternalService;
import org.joyqueue.nsr.service.internal.PartitionGroupInternalService;
import org.joyqueue.nsr.service.internal.PartitionGroupReplicaInternalService;
import org.joyqueue.nsr.service.internal.ProducerInternalService;
import org.joyqueue.nsr.service.internal.TopicInternalService;
import org.joyqueue.response.BooleanResponse;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetadataMonitorService
implements MetadataMonitorService {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMetadataMonitorService.class);
    private static final ExtensionPoint<InternalServiceProvider, String> SERVICE_PROVIDER_POINT = new ExtensionPointLazy(InternalServiceProvider.class);
    private ClusterManager clusterManager;
    private ClusterNameService clusterNameService;
    private MetadataSynchronizer metadataSynchronizer;
    private String source;
    private String target;
    private int interval;
    private ExecutorService syncThreadPool;

    public DefaultMetadataMonitorService(ClusterManager clusterManager, ClusterNameService clusterNameService) {
        this.clusterManager = clusterManager;
        this.clusterNameService = clusterNameService;
        this.metadataSynchronizer = new MetadataSynchronizer();
    }

    @Override
    public TopicConfig getTopicMetadata(String topic, boolean isCluster) {
        TopicName topicName = TopicName.parse((String)topic);
        if (isCluster) {
            return this.clusterManager.getTopicConfig(topicName);
        }
        return this.clusterNameService.getTopicConfig(topicName);
    }

    @Override
    public BooleanResponse getReadableResult(String topic, String app, String address) {
        TopicName topicName = TopicName.parse((String)topic);
        return this.clusterManager.checkReadable(topicName, app, address);
    }

    @Override
    public BooleanResponse getWritableResult(String topic, String app, String address) {
        TopicName topicName = TopicName.parse((String)topic);
        return this.clusterManager.checkWritable(topicName, app, address);
    }

    @Override
    public Consumer getConsumerMetadataByTopicAndApp(String topic, String app, boolean isCluster) {
        TopicName topicName = TopicName.parse((String)topic);
        if (isCluster) {
            return this.clusterManager.tryGetConsumer(topicName, app);
        }
        return this.clusterManager.getNameService().getConsumerByTopicAndApp(topicName, app);
    }

    @Override
    public Producer getProducerMetadataByTopicAndApp(String topic, String app, boolean isCluster) {
        TopicName topicName = TopicName.parse((String)topic);
        if (isCluster) {
            return this.clusterManager.tryGetProducer(topicName, app);
        }
        return this.clusterManager.getNameService().getProducerByTopicAndApp(topicName, app);
    }

    @Override
    public Object exportMetadata(String source) {
        InternalServiceProvider internalServiceProvider = null;
        internalServiceProvider = StringUtils.isBlank((CharSequence)source) ? (InternalServiceProvider)SERVICE_PROVIDER_POINT.get() : (InternalServiceProvider)SERVICE_PROVIDER_POINT.get((Object)source);
        if (internalServiceProvider == null) {
            return "source not exist";
        }
        HashMap result = Maps.newHashMap();
        result.put("topic", ((TopicInternalService)internalServiceProvider.getService(TopicInternalService.class)).getAll());
        result.put("partitionGroup", ((PartitionGroupInternalService)internalServiceProvider.getService(PartitionGroupInternalService.class)).getAll());
        result.put("partitionGroupReplica", ((PartitionGroupReplicaInternalService)internalServiceProvider.getService(PartitionGroupReplicaInternalService.class)).getAll());
        result.put("broker", ((BrokerInternalService)internalServiceProvider.getService(BrokerInternalService.class)).getAll());
        result.put("consumer", ((ConsumerInternalService)internalServiceProvider.getService(ConsumerInternalService.class)).getAll());
        result.put("producer", ((ProducerInternalService)internalServiceProvider.getService(ProducerInternalService.class)).getAll());
        result.put("dataCenter", ((DataCenterInternalService)internalServiceProvider.getService(DataCenterInternalService.class)).getAll());
        result.put("namespace", ((NamespaceInternalService)internalServiceProvider.getService(NamespaceInternalService.class)).getAll());
        result.put("config", ((ConfigInternalService)internalServiceProvider.getService(ConfigInternalService.class)).getAll());
        result.put("appToken", ((AppTokenInternalService)internalServiceProvider.getService(AppTokenInternalService.class)).getAll());
        return result;
    }

    @Override
    public Object syncMetadata(String source, String target, int interval, boolean onlyCompare) {
        this.source = source;
        this.target = target;
        this.interval = interval;
        if (interval != 0) {
            if (interval > 0) {
                if (this.syncThreadPool != null) {
                    this.syncThreadPool.shutdown();
                }
                this.syncThreadPool = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("joyqueue-metadata-synchronizer", true));
                this.syncThreadPool.execute(() -> {
                    while (true) {
                        InternalServiceProvider sourceInternalServiceProvider = (InternalServiceProvider)SERVICE_PROVIDER_POINT.get((Object)this.source);
                        InternalServiceProvider targetInternalServiceProvider = (InternalServiceProvider)SERVICE_PROVIDER_POINT.get((Object)this.target);
                        if (sourceInternalServiceProvider == null) {
                            logger.warn("source not exist");
                        }
                        if (targetInternalServiceProvider == null) {
                            logger.warn("target not exist");
                        }
                        Object result = this.metadataSynchronizer.sync(sourceInternalServiceProvider, targetInternalServiceProvider, onlyCompare);
                        logger.info("sync result: {}", (Object)JSON.toJSONString((Object)result));
                        try {
                            Thread.currentThread();
                            Thread.sleep(this.interval);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                });
            } else if (this.syncThreadPool != null) {
                this.syncThreadPool.shutdown();
            }
            return "success";
        }
        InternalServiceProvider sourceInternalServiceProvider = (InternalServiceProvider)SERVICE_PROVIDER_POINT.get((Object)source);
        InternalServiceProvider targetInternalServiceProvider = (InternalServiceProvider)SERVICE_PROVIDER_POINT.get((Object)target);
        if (sourceInternalServiceProvider == null) {
            return "source not exist";
        }
        if (targetInternalServiceProvider == null) {
            return "target not exist";
        }
        return this.metadataSynchronizer.sync(sourceInternalServiceProvider, targetInternalServiceProvider, onlyCompare);
    }

    @Override
    public Object queryMetadata(String source, String operator, List<Object> params) {
        InternalServiceProvider sourceInternalServiceProvider = null;
        sourceInternalServiceProvider = StringUtils.isBlank((CharSequence)source) ? (InternalServiceProvider)SERVICE_PROVIDER_POINT.get() : (InternalServiceProvider)SERVICE_PROVIDER_POINT.get((Object)source);
        if (sourceInternalServiceProvider == null) {
            return "source not exist";
        }
        OperationInternalService operationInternalService = (OperationInternalService)sourceInternalServiceProvider.getService(OperationInternalService.class);
        return operationInternalService.query(operator, params);
    }

    @Override
    public Object insertMetadata(String source, String operator, List<Object> params) {
        InternalServiceProvider sourceInternalServiceProvider = null;
        sourceInternalServiceProvider = StringUtils.isBlank((CharSequence)source) ? (InternalServiceProvider)SERVICE_PROVIDER_POINT.get() : (InternalServiceProvider)SERVICE_PROVIDER_POINT.get((Object)source);
        if (sourceInternalServiceProvider == null) {
            return "source not exist";
        }
        OperationInternalService operationInternalService = (OperationInternalService)sourceInternalServiceProvider.getService(OperationInternalService.class);
        return operationInternalService.insert(operator, params);
    }

    @Override
    public Object updateMetadata(String source, String operator, List<Object> params) {
        InternalServiceProvider sourceInternalServiceProvider = null;
        sourceInternalServiceProvider = StringUtils.isBlank((CharSequence)source) ? (InternalServiceProvider)SERVICE_PROVIDER_POINT.get() : (InternalServiceProvider)SERVICE_PROVIDER_POINT.get((Object)source);
        if (sourceInternalServiceProvider == null) {
            return "source not exist";
        }
        OperationInternalService operationInternalService = (OperationInternalService)sourceInternalServiceProvider.getService(OperationInternalService.class);
        return operationInternalService.update(operator, params);
    }

    @Override
    public Object deleteMetadata(String source, String operator, List<Object> params) {
        InternalServiceProvider sourceInternalServiceProvider = null;
        sourceInternalServiceProvider = StringUtils.isBlank((CharSequence)source) ? (InternalServiceProvider)SERVICE_PROVIDER_POINT.get() : (InternalServiceProvider)SERVICE_PROVIDER_POINT.get((Object)source);
        if (sourceInternalServiceProvider == null) {
            return "source not exist";
        }
        OperationInternalService operationInternalService = (OperationInternalService)sourceInternalServiceProvider.getService(OperationInternalService.class);
        return operationInternalService.delete(operator, params);
    }

    @Override
    public String getConfigMetadata(String key) {
        Property property = this.clusterManager.getPropertySupplier().getProperty(key);
        if (property == null) {
            return null;
        }
        return String.valueOf(property.getValue());
    }

    @Override
    public Map<String, String> getConfigsMetadata() {
        HashMap result = Maps.newHashMap();
        for (Property property : this.clusterManager.getPropertySupplier().getProperties()) {
            result.put(String.valueOf(property.getKey()), String.valueOf(property.getValue()));
        }
        return result;
    }

    @Override
    public String updateConfigMetadata(String key, String group, String value) {
        PropertySupplier propertySupplier = this.clusterManager.getPropertySupplier();
        if (!(propertySupplier instanceof Configuration)) {
            return "failed";
        }
        Configuration configuration = (Configuration)propertySupplier;
        configuration.addProperty(key, value, group);
        return "success";
    }

    @Override
    public String getMetadataCluster() {
        InternalServiceProvider internalServiceProvider = (InternalServiceProvider)SERVICE_PROVIDER_POINT.get();
        ClusterInternalService clusterInternalService = (ClusterInternalService)internalServiceProvider.getService(ClusterInternalService.class);
        return clusterInternalService.getCluster();
    }

    @Override
    public String addMetadataNode(String uri) {
        InternalServiceProvider internalServiceProvider = (InternalServiceProvider)SERVICE_PROVIDER_POINT.get();
        ClusterInternalService clusterInternalService = (ClusterInternalService)internalServiceProvider.getService(ClusterInternalService.class);
        return clusterInternalService.addNode(URI.create(uri));
    }

    @Override
    public String removeMetadataNode(String uri) {
        InternalServiceProvider internalServiceProvider = (InternalServiceProvider)SERVICE_PROVIDER_POINT.get();
        ClusterInternalService clusterInternalService = (ClusterInternalService)internalServiceProvider.getService(ClusterInternalService.class);
        return clusterInternalService.removeNode(URI.create(uri));
    }

    @Override
    public String updateMetadataNode(List<String> uris) {
        InternalServiceProvider internalServiceProvider = (InternalServiceProvider)SERVICE_PROVIDER_POINT.get();
        ClusterInternalService clusterInternalService = (ClusterInternalService)internalServiceProvider.getService(ClusterInternalService.class);
        ArrayList param = Lists.newArrayListWithCapacity((int)uris.size());
        for (String uri : uris) {
            param.add(URI.create(uri));
        }
        return clusterInternalService.updateNodes((List)param);
    }

    @Override
    public String executeMetadataCommand(String command, List<String> args) {
        InternalServiceProvider internalServiceProvider = (InternalServiceProvider)SERVICE_PROVIDER_POINT.get();
        ClusterInternalService clusterInternalService = (ClusterInternalService)internalServiceProvider.getService(ClusterInternalService.class);
        return clusterInternalService.execute(command, args);
    }
}

