/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.service.support;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.monitor.converter.BrokerMonitorConverter;
import org.joyqueue.broker.monitor.service.PartitionMonitorService;
import org.joyqueue.broker.monitor.stat.AppStat;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.broker.monitor.stat.ElectionEventStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.PartitionStat;
import org.joyqueue.broker.monitor.stat.ReplicaNodeStat;
import org.joyqueue.broker.monitor.stat.TopicStat;
import org.joyqueue.monitor.PartitionGroupMonitorInfo;
import org.joyqueue.monitor.PartitionMonitorInfo;
import org.joyqueue.store.StoreManagementService;

public class DefaultPartitionMonitorService
implements PartitionMonitorService {
    private BrokerStat brokerStat;
    private StoreManagementService storeManagementService;
    private ElectionService electionManager;

    public DefaultPartitionMonitorService(BrokerStat brokerStat, StoreManagementService storeManagementService, ElectionService electionManager) {
        this.brokerStat = brokerStat;
        this.storeManagementService = storeManagementService;
        this.electionManager = electionManager;
    }

    @Override
    public PartitionMonitorInfo getPartitionInfoByTopic(String topic, short partition) {
        PartitionStat partitionStat = this.brokerStat.getOrCreateTopicStat(topic).getPartitionStat(partition);
        return this.convertPartitionMonitorInfo(partitionStat);
    }

    @Override
    public List<PartitionMonitorInfo> getPartitionInfosByTopic(String topic) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry entry : topicStat.getPartitionGroupStatMap().entrySet()) {
            for (Map.Entry partitionStatEntry : ((PartitionGroupStat)entry.getValue()).getPartitionStatMap().entrySet()) {
                PartitionMonitorInfo partitionMonitorInfo = this.convertPartitionMonitorInfo((PartitionStat)partitionStatEntry.getValue());
                result.add(partitionMonitorInfo);
            }
        }
        return result;
    }

    @Override
    public PartitionMonitorInfo getPartitionInfoByTopicAndApp(String topic, String app, short partition) {
        PartitionStat partitionStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app).getPartitionStat(partition);
        return this.convertPartitionMonitorInfo(partitionStat);
    }

    @Override
    public List<PartitionMonitorInfo> getPartitionInfosByTopicAndApp(String topic, String app) {
        AppStat appStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app);
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry entry : appStat.getPartitionGroupStatMap().entrySet()) {
            for (Map.Entry partitionStatEntry : ((PartitionGroupStat)entry.getValue()).getPartitionStatMap().entrySet()) {
                PartitionMonitorInfo partitionMonitorInfo = this.convertPartitionMonitorInfo((PartitionStat)partitionStatEntry.getValue());
                result.add(partitionMonitorInfo);
            }
        }
        return result;
    }

    @Override
    public PartitionGroupMonitorInfo getPartitionGroupInfoByTopic(String topic, int partitionGroup) {
        PartitionGroupStat partitionGroupStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreatePartitionGroupStat(partitionGroup);
        return this.convertPartitionGroupMonitorInfo(partitionGroupStat);
    }

    @Override
    public ElectionEventStat getReplicaRecentElectionEvent(String topic, int partitionGroup) {
        PartitionGroupStat partitionGroupStat;
        TopicStat topicStat = (TopicStat)this.brokerStat.getTopicStats().get(topic);
        if (topicStat != null && (partitionGroupStat = (PartitionGroupStat)topicStat.getPartitionGroupStatMap().get(partitionGroup)) != null) {
            return partitionGroupStat.getElectionEventStat();
        }
        return null;
    }

    @Override
    public List<PartitionGroupMonitorInfo> getPartitionGroupInfosByTopic(String topic) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry entry : topicStat.getPartitionGroupStatMap().entrySet()) {
            PartitionGroupMonitorInfo partitionGroupMonitorInfo = this.convertPartitionGroupMonitorInfo((PartitionGroupStat)entry.getValue());
            result.add(partitionGroupMonitorInfo);
        }
        return result;
    }

    @Override
    public PartitionGroupMonitorInfo getPartitionGroupInfoByTopicAndApp(String topic, String app, int partitionGroup) {
        PartitionGroupStat partitionGroupStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app).getOrCreatePartitionGroupStat(partitionGroup);
        return this.convertPartitionGroupMonitorInfo(partitionGroupStat);
    }

    @Override
    public List<PartitionGroupMonitorInfo> getPartitionGroupInfosByTopicAndApp(String topic, String app) {
        AppStat appStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app);
        LinkedList result = Lists.newLinkedList();
        for (Map.Entry entry : appStat.getPartitionGroupStatMap().entrySet()) {
            PartitionGroupMonitorInfo partitionGroupMonitorInfo = this.convertPartitionGroupMonitorInfo((PartitionGroupStat)entry.getValue());
            result.add(partitionGroupMonitorInfo);
        }
        return result;
    }

    @Override
    public ReplicaNodeStat getReplicaState(String topic, int partitionGroup) {
        ReplicaNodeStat replicaNodeStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreatePartitionGroupStat(partitionGroup).getReplicationStat().getStat();
        replicaNodeStat.setBrokerId(this.brokerStat.getBrokerId());
        return replicaNodeStat;
    }

    protected PartitionGroupMonitorInfo convertPartitionGroupMonitorInfo(PartitionGroupStat partitionGroupStat) {
        StoreManagementService.PartitionGroupMetric partitionGroupMetric = this.storeManagementService.partitionGroupMetric(partitionGroupStat.getTopic(), partitionGroupStat.getPartitionGroup());
        PartitionGroupMonitorInfo partitionGroupMonitorInfo = new PartitionGroupMonitorInfo();
        partitionGroupMonitorInfo.setTopic(partitionGroupStat.getTopic());
        partitionGroupMonitorInfo.setApp(partitionGroupStat.getApp());
        partitionGroupMonitorInfo.setPartitionGroup(partitionGroupStat.getPartitionGroup());
        partitionGroupMonitorInfo.setLeftPosition(partitionGroupMetric.getLeftPosition());
        partitionGroupMonitorInfo.setRightPosition(partitionGroupMetric.getRightPosition());
        partitionGroupMonitorInfo.setIndexPosition(partitionGroupMetric.getIndexPosition());
        partitionGroupMonitorInfo.setFlushPosition(partitionGroupMetric.getFlushPosition());
        partitionGroupMonitorInfo.setReplicationPosition(partitionGroupMetric.getReplicationPosition());
        partitionGroupMonitorInfo.setEnQueue(BrokerMonitorConverter.convertEnQueueMonitorInfo(partitionGroupStat.getEnQueueStat()));
        partitionGroupMonitorInfo.setDeQueue(BrokerMonitorConverter.convertDeQueueMonitorInfo(partitionGroupStat.getDeQueueStat()));
        partitionGroupMonitorInfo.setReplication(BrokerMonitorConverter.convertReplicationMonitorInfo(partitionGroupStat.getReplicationStat()));
        return partitionGroupMonitorInfo;
    }

    protected PartitionMonitorInfo convertPartitionMonitorInfo(PartitionStat partitionStat) {
        PartitionMonitorInfo partitionMonitorInfo = new PartitionMonitorInfo();
        partitionMonitorInfo.setTopic(partitionStat.getTopic());
        partitionMonitorInfo.setApp(partitionStat.getApp());
        partitionMonitorInfo.setPartition(partitionStat.getPartition());
        partitionMonitorInfo.setEnQueue(BrokerMonitorConverter.convertEnQueueMonitorInfo(partitionStat.getEnQueueStat()));
        partitionMonitorInfo.setDeQueue(BrokerMonitorConverter.convertDeQueueMonitorInfo(partitionStat.getDeQueueStat()));
        return partitionMonitorInfo;
    }
}

