/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.service.support;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.monitor.converter.BrokerMonitorConverter;
import org.joyqueue.broker.monitor.service.ProducerMonitorService;
import org.joyqueue.broker.monitor.stat.AppStat;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.PartitionStat;
import org.joyqueue.broker.monitor.stat.ProducerStat;
import org.joyqueue.broker.monitor.stat.TopicStat;
import org.joyqueue.model.Pager;
import org.joyqueue.monitor.ProducerMonitorInfo;
import org.joyqueue.monitor.ProducerPartitionGroupMonitorInfo;
import org.joyqueue.monitor.ProducerPartitionMonitorInfo;
import org.joyqueue.store.StoreManagementService;

public class DefaultProducerMonitorService
implements ProducerMonitorService {
    private BrokerStat brokerStat;
    private StoreManagementService storeManagementService;
    private ClusterManager clusterManager;

    public DefaultProducerMonitorService(BrokerStat brokerStat, StoreManagementService storeManagementService, ClusterManager clusterManager) {
        this.brokerStat = brokerStat;
        this.storeManagementService = storeManagementService;
        this.clusterManager = clusterManager;
    }

    @Override
    public Pager<ProducerMonitorInfo> getProduceInfos(int page, int pageSize) {
        int total = 0;
        int startIndex = (page - 1) * pageSize;
        int endIndex = startIndex + pageSize;
        int index = 0;
        ArrayList data = Lists.newArrayListWithCapacity((int)pageSize);
        for (Map.Entry topicStatEntry : this.brokerStat.getTopicStats().entrySet()) {
            for (Map.Entry appStatEntry : ((TopicStat)topicStatEntry.getValue()).getAppStats().entrySet()) {
                if (index >= startIndex && index < endIndex) {
                    data.add(this.convertProducerMonitorInfo(((AppStat)appStatEntry.getValue()).getProducerStat()));
                }
                ++index;
            }
            total += ((TopicStat)topicStatEntry.getValue()).getAppStats().size();
        }
        return new Pager(page, pageSize, total, (List)data);
    }

    @Override
    public ProducerMonitorInfo getProducerInfoByTopicAndApp(String topic, String app) {
        AppStat appStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app);
        return this.convertProducerMonitorInfo(appStat.getProducerStat());
    }

    @Override
    public List<ProducerPartitionMonitorInfo> getProducerPartitionInfos(String topic, String app) {
        ProducerStat producerStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app).getProducerStat();
        LinkedList result = Lists.newLinkedList();
        StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(producerStat.getTopic());
        for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
            PartitionGroupStat partitionGroupStat = producerStat.getOrCreatePartitionGroupStat(partitionGroupMetric.getPartitionGroup());
            for (StoreManagementService.PartitionMetric partitionMetric : partitionGroupMetric.getPartitionMetrics()) {
                if (!this.clusterManager.isLeader(topic, partitionMetric.getPartition())) continue;
                PartitionStat partitionStat = partitionGroupStat.getOrCreatePartitionStat(partitionMetric.getPartition());
                ProducerPartitionMonitorInfo producerPartitionMonitorInfo = new ProducerPartitionMonitorInfo();
                producerPartitionMonitorInfo.setPartition(partitionMetric.getPartition());
                producerPartitionMonitorInfo.setTopic(topic);
                producerPartitionMonitorInfo.setApp(app);
                producerPartitionMonitorInfo.setEnQueue(BrokerMonitorConverter.convertEnQueueMonitorInfo(partitionStat.getEnQueueStat()));
                result.add(producerPartitionMonitorInfo);
            }
        }
        return result;
    }

    @Override
    public ProducerPartitionMonitorInfo getProducerPartitionInfoByTopicAndApp(String topic, String app, short partition) {
        ProducerStat producerStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app).getProducerStat();
        return this.convertProducerPartitionMonitorInfo(producerStat, partition);
    }

    @Override
    public List<ProducerPartitionGroupMonitorInfo> getProducerPartitionGroupInfos(String topic, String app) {
        ProducerStat producerStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app).getProducerStat();
        LinkedList result = Lists.newLinkedList();
        StoreManagementService.TopicMetric topicMetric = this.storeManagementService.topicMetric(producerStat.getTopic());
        for (StoreManagementService.PartitionGroupMetric partitionGroupMetric : topicMetric.getPartitionGroupMetrics()) {
            if (!this.clusterManager.isLeader(topic, partitionGroupMetric.getPartitionGroup())) continue;
            result.add(this.convertProducerPartitionGroupMonitorInfo(producerStat, partitionGroupMetric.getPartitionGroup()));
        }
        return result;
    }

    @Override
    public ProducerPartitionGroupMonitorInfo getProducerPartitionGroupInfoByTopicAndApp(String topic, String app, int partitionGroupId) {
        ProducerStat producerStat = this.brokerStat.getOrCreateTopicStat(topic).getOrCreateAppStat(app).getProducerStat();
        return this.convertProducerPartitionGroupMonitorInfo(producerStat, partitionGroupId);
    }

    protected ProducerPartitionGroupMonitorInfo convertProducerPartitionGroupMonitorInfo(ProducerStat producerStat, int partitionGroupId) {
        ProducerPartitionGroupMonitorInfo producerPartitionGroupMonitorInfo = new ProducerPartitionGroupMonitorInfo();
        producerPartitionGroupMonitorInfo.setTopic(producerStat.getTopic());
        producerPartitionGroupMonitorInfo.setApp(producerStat.getApp());
        producerPartitionGroupMonitorInfo.setPartitionGroupId(partitionGroupId);
        producerPartitionGroupMonitorInfo.setEnQueue(BrokerMonitorConverter.convertEnQueueMonitorInfo(producerStat.getOrCreatePartitionGroupStat(partitionGroupId).getEnQueueStat()));
        return producerPartitionGroupMonitorInfo;
    }

    protected ProducerPartitionMonitorInfo convertProducerPartitionMonitorInfo(ProducerStat producerStat, short partition) {
        ProducerPartitionMonitorInfo producerPartitionMonitorInfo = new ProducerPartitionMonitorInfo();
        producerPartitionMonitorInfo.setTopic(producerStat.getTopic());
        producerPartitionMonitorInfo.setApp(producerStat.getApp());
        producerPartitionMonitorInfo.setPartition(partition);
        producerPartitionMonitorInfo.setEnQueue(BrokerMonitorConverter.convertEnQueueMonitorInfo(producerStat.getEnQueueStat()));
        return producerPartitionMonitorInfo;
    }

    protected ProducerMonitorInfo convertProducerMonitorInfo(ProducerStat producerStat) {
        ProducerMonitorInfo producerMonitorInfo = new ProducerMonitorInfo();
        producerMonitorInfo.setTopic(producerStat.getTopic());
        producerMonitorInfo.setApp(producerStat.getApp());
        producerMonitorInfo.setConnections(producerStat.getConnectionStat().getConnection());
        producerMonitorInfo.setEnQueue(BrokerMonitorConverter.convertEnQueueMonitorInfo(producerStat.getEnQueueStat()));
        return producerMonitorInfo;
    }
}

