/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.service.support;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.broker.monitor.converter.BrokerMonitorConverter;
import org.joyqueue.broker.monitor.service.TopicMonitorService;
import org.joyqueue.broker.monitor.stat.BrokerStat;
import org.joyqueue.broker.monitor.stat.TopicStat;
import org.joyqueue.model.Pager;
import org.joyqueue.monitor.TopicMonitorInfo;
import org.joyqueue.store.StoreManagementService;

public class DefaultTopicMonitorService
implements TopicMonitorService {
    private BrokerStat brokerStat;
    private StoreManagementService storeManagementService;

    public DefaultTopicMonitorService(BrokerStat brokerStat, StoreManagementService storeManagementService) {
        this.brokerStat = brokerStat;
        this.storeManagementService = storeManagementService;
    }

    @Override
    public Pager<TopicMonitorInfo> getTopicInfos(int page, int pageSize) {
        int total = this.storeManagementService.storeMetrics().length;
        int startIndex = (page - 1) * pageSize;
        int endIndex = startIndex + pageSize;
        int index = 0;
        ArrayList data = Lists.newArrayListWithCapacity((int)pageSize);
        for (StoreManagementService.TopicMetric topicMetric : this.storeManagementService.storeMetrics()) {
            if (!topicMetric.isUsabled() || index < startIndex || index >= endIndex) continue;
            TopicMonitorInfo topicMonitorInfo = this.getTopicInfoByTopic(topicMetric.getTopic());
            TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topicMonitorInfo.getTopic());
            data.add(this.convertTopicMonitorInfo(topicStat));
        }
        return new Pager(page, pageSize, total, (List)data);
    }

    @Override
    public TopicMonitorInfo getTopicInfoByTopic(String topic) {
        TopicStat topicStat = this.brokerStat.getOrCreateTopicStat(topic);
        return this.convertTopicMonitorInfo(topicStat);
    }

    @Override
    public List<TopicMonitorInfo> getTopicInfoByTopics(List<String> topics) {
        ArrayList result = Lists.newArrayListWithCapacity((int)topics.size());
        for (String topic : topics) {
            TopicMonitorInfo topicMonitorInfo = this.convertTopicMonitorInfo(this.brokerStat.getOrCreateTopicStat(topic));
            result.add(topicMonitorInfo);
        }
        return result;
    }

    protected TopicMonitorInfo convertTopicMonitorInfo(TopicStat topicStat) {
        TopicMonitorInfo topicMonitorInfo = new TopicMonitorInfo();
        topicMonitorInfo.setTopic(topicStat.getTopic());
        topicMonitorInfo.setConnection(BrokerMonitorConverter.convertConnectionMonitorInfo(topicStat.getConnectionStat()));
        topicMonitorInfo.setEnQueue(BrokerMonitorConverter.convertEnQueueMonitorInfo(topicStat.getEnQueueStat()));
        topicMonitorInfo.setDeQueue(BrokerMonitorConverter.convertDeQueueMonitorInfo(topicStat.getDeQueueStat()));
        return topicMonitorInfo;
    }
}

