/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.stat;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.monitor.stat.ConnectionStat;
import org.joyqueue.broker.monitor.stat.ConsumerStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.PartitionStat;
import org.joyqueue.broker.monitor.stat.ProducerStat;

public class AppStat
implements Serializable {
    private static final long serialVersionUID = -1925788827902461246L;
    private String topic;
    private String app;
    private ConnectionStat connectionStat = new ConnectionStat();
    private ConcurrentMap<Integer, PartitionGroupStat> partitionGroupStatMap = Maps.newConcurrentMap();
    private ConsumerStat consumerStat;
    private ProducerStat producerStat;

    public AppStat(String topic, String app) {
        this.topic = topic;
        this.app = app;
        this.consumerStat = new ConsumerStat(topic, app);
        this.producerStat = new ProducerStat(topic, app);
    }

    public PartitionStat getPartitionStat(short partition) {
        for (Map.Entry entry : this.partitionGroupStatMap.entrySet()) {
            PartitionStat partitionStat = (PartitionStat)((PartitionGroupStat)entry.getValue()).getPartitionStatMap().get(partition);
            if (partitionStat == null) continue;
            return partitionStat;
        }
        return new PartitionStat(this.topic, this.app, partition);
    }

    public PartitionGroupStat getOrCreatePartitionGroupStat(int partitionGroup) {
        PartitionGroupStat partitionGroupStat = (PartitionGroupStat)this.partitionGroupStatMap.get(partitionGroup);
        if (partitionGroupStat == null) {
            this.partitionGroupStatMap.putIfAbsent(partitionGroup, new PartitionGroupStat(this.topic, this.app, partitionGroup));
            partitionGroupStat = (PartitionGroupStat)this.partitionGroupStatMap.get(partitionGroup);
        }
        return partitionGroupStat;
    }

    public void removePartitionGroup(int partitionGroup) {
        this.partitionGroupStatMap.remove(partitionGroup);
    }

    public void removePartition(short partition) {
        for (Map.Entry entry : this.partitionGroupStatMap.entrySet()) {
            ((PartitionGroupStat)entry.getValue()).getPartitionStatMap().remove(partition);
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public String getApp() {
        return this.app;
    }

    public ConnectionStat getConnectionStat() {
        return this.connectionStat;
    }

    public ConsumerStat getConsumerStat() {
        return this.consumerStat;
    }

    public ProducerStat getProducerStat() {
        return this.producerStat;
    }

    public ConcurrentMap<Integer, PartitionGroupStat> getPartitionGroupStatMap() {
        return this.partitionGroupStatMap;
    }
}

