/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.stat;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.monitor.stat.ConnectionStat;
import org.joyqueue.broker.monitor.stat.DeQueueStat;
import org.joyqueue.broker.monitor.stat.EnQueueStat;
import org.joyqueue.broker.monitor.stat.JVMStat;
import org.joyqueue.broker.monitor.stat.ReplicationStat;
import org.joyqueue.broker.monitor.stat.TopicStat;

public class BrokerStat
implements Serializable {
    private static final long serialVersionUID = -4637157513730009816L;
    public static final int VERSION = 1;
    private Integer brokerId;
    private JVMStat jvmStat = new JVMStat();
    private Integer storagePercent;
    private ConnectionStat connectionStat = new ConnectionStat();
    private EnQueueStat enQueueStat = new EnQueueStat();
    private DeQueueStat deQueueStat = new DeQueueStat();
    private ConcurrentMap<String, TopicStat> topicStatMap = Maps.newConcurrentMap();
    private ReplicationStat replicationStat = new ReplicationStat();

    public BrokerStat(Integer brokerId) {
        this.brokerId = brokerId;
    }

    public TopicStat getOrCreateTopicStat(String topic) {
        TopicStat topicStat = (TopicStat)this.topicStatMap.get(topic);
        if (topicStat == null) {
            this.topicStatMap.putIfAbsent(topic, new TopicStat(topic));
            topicStat = (TopicStat)this.topicStatMap.get(topic);
        }
        return topicStat;
    }

    public Integer getStoragePercent() {
        return this.storagePercent;
    }

    public void setStoragePercent(Integer storagePercent) {
        this.storagePercent = storagePercent;
    }

    public ConnectionStat getConnectionStat() {
        return this.connectionStat;
    }

    public DeQueueStat getDeQueueStat() {
        return this.deQueueStat;
    }

    public EnQueueStat getEnQueueStat() {
        return this.enQueueStat;
    }

    public ConcurrentMap<String, TopicStat> getTopicStats() {
        return this.topicStatMap;
    }

    public ReplicationStat getReplicationStat() {
        return this.replicationStat;
    }

    public Integer getBrokerId() {
        return this.brokerId;
    }

    public JVMStat getJvmStat() {
        return this.jvmStat;
    }

    public void setJvmStat(JVMStat jvmStat) {
        this.jvmStat = jvmStat;
    }
}

