/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.stat;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.monitor.metrics.Metrics;
import org.joyqueue.monitor.Client;

public class ConnectionStat {
    private Metrics consumer = new Metrics();
    private Metrics producer = new Metrics();
    private ConcurrentMap<String, Client> connectionMap = Maps.newConcurrentMap();

    public void incrConsumer() {
        this.incrConsumer(1);
    }

    public void incrConsumer(int count) {
        this.consumer.mark(count);
    }

    public void decrConsumer() {
        this.decrConsumer(1);
    }

    public void decrConsumer(int count) {
        this.consumer.mark(-count);
    }

    public void incrProducer() {
        this.incrProducer(1);
    }

    public void incrProducer(int count) {
        this.producer.mark(count);
    }

    public void decrProducer() {
        this.decrProducer(1);
    }

    public void decrProducer(int count) {
        this.producer.mark(-count);
    }

    public int getConsumer() {
        return (int)this.consumer.getCount();
    }

    public int getProducer() {
        return (int)this.producer.getCount();
    }

    public int getConnection() {
        return this.connectionMap.size();
    }

    public Client getConnection(String connectionId) {
        return (Client)this.connectionMap.get(connectionId);
    }

    public boolean addConnection(Client client) {
        return this.connectionMap.putIfAbsent(client.getConnectionId(), client) == null;
    }

    public boolean removeConnection(String connectionId) {
        return this.connectionMap.remove(connectionId) != null;
    }

    public ConcurrentMap<String, Client> getConnectionMap() {
        return this.connectionMap;
    }
}

