/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.stat;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.monitor.stat.ConnectionStat;
import org.joyqueue.broker.monitor.stat.DeQueueStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.RetryStat;

public class ConsumerStat {
    private String topic;
    private String app;
    private DeQueueStat deQueueStat = new DeQueueStat();
    private RetryStat retryStat = new RetryStat();
    private ConnectionStat connectionStat = new ConnectionStat();
    private ConcurrentMap<Integer, PartitionGroupStat> partitionGroupStatMap = Maps.newConcurrentMap();

    public ConsumerStat(String topic, String app) {
        this.topic = topic;
        this.app = app;
    }

    public PartitionGroupStat getOrCreatePartitionGroupStat(int partitionGroup) {
        PartitionGroupStat partitionGroupStat = (PartitionGroupStat)this.partitionGroupStatMap.get(partitionGroup);
        if (partitionGroupStat == null) {
            this.partitionGroupStatMap.putIfAbsent(partitionGroup, new PartitionGroupStat(this.topic, this.app, partitionGroup));
            partitionGroupStat = (PartitionGroupStat)this.partitionGroupStatMap.get(partitionGroup);
        }
        return partitionGroupStat;
    }

    public void clear() {
        this.deQueueStat = new DeQueueStat();
        this.retryStat = new RetryStat();
        this.connectionStat = new ConnectionStat();
        this.partitionGroupStatMap.clear();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getApp() {
        return this.app;
    }

    public DeQueueStat getDeQueueStat() {
        return this.deQueueStat;
    }

    public RetryStat getRetryStat() {
        return this.retryStat;
    }

    public ConnectionStat getConnectionStat() {
        return this.connectionStat;
    }

    public ConcurrentMap<Integer, PartitionGroupStat> getPartitionGroupStatMap() {
        return this.partitionGroupStatMap;
    }
}

