/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.stat;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.monitor.stat.DeQueueStat;
import org.joyqueue.broker.monitor.stat.ElectionEventStat;
import org.joyqueue.broker.monitor.stat.EnQueueStat;
import org.joyqueue.broker.monitor.stat.PartitionStat;
import org.joyqueue.broker.monitor.stat.ReplicationStat;

public class PartitionGroupStat
implements Serializable {
    private String topic;
    private String app;
    private int partitionGroup;
    private EnQueueStat enQueueStat = new EnQueueStat();
    private DeQueueStat deQueueStat = new DeQueueStat();
    private ReplicationStat replicationStat = new ReplicationStat();
    private ElectionEventStat electionEventStat = new ElectionEventStat();
    private ConcurrentMap<Short, PartitionStat> partitionStatMap = Maps.newConcurrentMap();

    public PartitionGroupStat(String topic, String app, int partitionGroup) {
        this.topic = topic;
        this.app = app;
        this.partitionGroup = partitionGroup;
    }

    public PartitionStat getOrCreatePartitionStat(short partition) {
        PartitionStat partitionStat = (PartitionStat)this.partitionStatMap.get(partition);
        if (partitionStat == null) {
            this.partitionStatMap.putIfAbsent(partition, new PartitionStat(this.topic, this.app, partition));
            partitionStat = (PartitionStat)this.partitionStatMap.get(partition);
        }
        return partitionStat;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getApp() {
        return this.app;
    }

    public EnQueueStat getEnQueueStat() {
        return this.enQueueStat;
    }

    public DeQueueStat getDeQueueStat() {
        return this.deQueueStat;
    }

    public ElectionEventStat getElectionEventStat() {
        return this.electionEventStat;
    }

    public int getPartitionGroup() {
        return this.partitionGroup;
    }

    public ConcurrentMap<Short, PartitionStat> getPartitionStatMap() {
        return this.partitionStatMap;
    }

    public ReplicationStat getReplicationStat() {
        return this.replicationStat;
    }
}

