/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.monitor.stat;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.monitor.stat.AppStat;
import org.joyqueue.broker.monitor.stat.ConnectionStat;
import org.joyqueue.broker.monitor.stat.DeQueueStat;
import org.joyqueue.broker.monitor.stat.EnQueueStat;
import org.joyqueue.broker.monitor.stat.PartitionGroupStat;
import org.joyqueue.broker.monitor.stat.PartitionStat;

public class TopicStat
implements Serializable {
    private static final long serialVersionUID = -2410477972367211215L;
    private String topic;
    private ConnectionStat connectionStat = new ConnectionStat();
    private EnQueueStat enQueueStat = new EnQueueStat();
    private DeQueueStat deQueueStat = new DeQueueStat();
    private ConcurrentMap<String, AppStat> appStatMap = Maps.newConcurrentMap();
    private ConcurrentMap<Integer, PartitionGroupStat> partitionGroupStatMap = Maps.newConcurrentMap();
    private long storeSize;

    public TopicStat(String topic) {
        this.topic = topic;
    }

    public PartitionStat getPartitionStat(short partition) {
        for (Map.Entry entry : this.partitionGroupStatMap.entrySet()) {
            PartitionStat partitionStat = (PartitionStat)((PartitionGroupStat)entry.getValue()).getPartitionStatMap().get(partition);
            if (partitionStat == null) continue;
            return partitionStat;
        }
        return new PartitionStat(this.topic, null, partition);
    }

    public PartitionGroupStat getOrCreatePartitionGroupStat(int partitionGroup) {
        PartitionGroupStat partitionGroupStat = (PartitionGroupStat)this.partitionGroupStatMap.get(partitionGroup);
        if (partitionGroupStat == null) {
            this.partitionGroupStatMap.putIfAbsent(partitionGroup, new PartitionGroupStat(this.topic, null, partitionGroup));
            partitionGroupStat = (PartitionGroupStat)this.partitionGroupStatMap.get(partitionGroup);
        }
        return partitionGroupStat;
    }

    public AppStat getOrCreateAppStat(String app) {
        AppStat appStat = (AppStat)this.appStatMap.get(app);
        if (appStat == null) {
            this.appStatMap.putIfAbsent(app, new AppStat(this.topic, app));
            appStat = (AppStat)this.appStatMap.get(app);
        }
        return appStat;
    }

    public void removePartitionGroup(int partitionGroup) {
        this.partitionGroupStatMap.remove(partitionGroup);
        for (Map.Entry entry : this.appStatMap.entrySet()) {
            ((AppStat)entry.getValue()).removePartitionGroup(partitionGroup);
        }
    }

    public void removePartition(short partition) {
        for (Map.Entry entry : this.partitionGroupStatMap.entrySet()) {
            ((PartitionGroupStat)entry.getValue()).getPartitionStatMap().remove(partition);
        }
        for (Map.Entry entry : this.appStatMap.entrySet()) {
            ((AppStat)entry.getValue()).removePartition(partition);
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public ConcurrentMap<String, AppStat> getAppStats() {
        return this.appStatMap;
    }

    public EnQueueStat getEnQueueStat() {
        return this.enQueueStat;
    }

    public DeQueueStat getDeQueueStat() {
        return this.deQueueStat;
    }

    public ConnectionStat getConnectionStat() {
        return this.connectionStat;
    }

    public ConcurrentMap<Integer, PartitionGroupStat> getPartitionGroupStatMap() {
        return this.partitionGroupStatMap;
    }

    public void setStoreSize(long storeSize) {
        this.storeSize = storeSize;
    }

    public long getStoreSize() {
        return this.storeSize;
    }
}

