/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network;

import com.google.common.collect.Lists;
import com.jd.laf.extension.ExtensionManager;
import java.util.List;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.network.BrokerCommandHandler;
import org.joyqueue.broker.network.support.BrokerCommandHandlerRegistrar;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.support.DefaultCommandHandlerFactory;

public class BrokerCommandHandlerFactory
extends DefaultCommandHandlerFactory {
    private BrokerContext brokerContext;
    private List<BrokerCommandHandler> commandHandlers;

    public BrokerCommandHandlerFactory(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
        this.commandHandlers = this.loadCommandHandlers();
        this.initCommandHandlers(this.commandHandlers);
        this.registerCommandHandlers(this.commandHandlers);
        BrokerCommandHandlerRegistrar.register(brokerContext, this);
    }

    protected List<BrokerCommandHandler> loadCommandHandlers() {
        return Lists.newArrayList((Iterable)ExtensionManager.getOrLoadExtensions(BrokerCommandHandler.class));
    }

    protected void initCommandHandlers(List<BrokerCommandHandler> commandHandlers) {
        for (BrokerCommandHandler commandHandler : commandHandlers) {
            if (!(commandHandler instanceof BrokerContextAware)) continue;
            ((BrokerContextAware)((Object)commandHandler)).setBrokerContext(this.brokerContext);
        }
    }

    protected void registerCommandHandlers(List<BrokerCommandHandler> commandHandlers) {
        for (BrokerCommandHandler commandHandler : commandHandlers) {
            super.register((CommandHandler)commandHandler);
        }
    }
}

