/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network;

import com.google.common.base.Preconditions;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.network.backend.BackendServer;
import org.joyqueue.broker.network.frontend.FrontendServer;
import org.joyqueue.broker.network.listener.BrokerTransportListener;
import org.joyqueue.broker.network.protocol.ProtocolManager;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.toolkit.service.Service;

public class BrokerServer
extends Service {
    private FrontendServer frontendServer;
    private BackendServer backendServer;
    private BrokerTransportListener transportListener;

    public BrokerServer(BrokerContext brokerContext, ProtocolManager protocolManager) {
        Preconditions.checkArgument((brokerContext != null ? 1 : 0) != 0, (Object)"broker context can not be null");
        Preconditions.checkArgument((protocolManager != null ? 1 : 0) != 0, (Object)"protocol manager can not be null");
        ServerConfig frontendConfig = brokerContext.getBrokerConfig().getFrontendConfig();
        ServerConfig backendConfig = brokerContext.getBrokerConfig().getBackendConfig();
        SessionManager sessionManager = brokerContext.getSessionManager();
        frontendConfig.setAcceptThreadName("joyqueue-frontend-accept-eventLoop");
        frontendConfig.setIoThreadName("joyqueue-frontend-io-eventLoop");
        backendConfig.setAcceptThreadName("joyqueue-backend-accept-eventLoop");
        backendConfig.setIoThreadName("joyqueue-backend-io-eventLoop");
        this.transportListener = new BrokerTransportListener(sessionManager);
        this.frontendServer = new FrontendServer(frontendConfig, brokerContext, protocolManager);
        this.backendServer = new BackendServer(backendConfig, brokerContext);
        this.frontendServer.addListener(this.transportListener);
        this.backendServer.addListener(this.transportListener);
    }

    protected void doStart() throws Exception {
        this.backendServer.start();
        this.frontendServer.start();
    }

    protected void doStop() {
        this.frontendServer.removeListener(this.transportListener);
        this.backendServer.removeListener(this.transportListener);
        this.frontendServer.stop();
        this.backendServer.stop();
    }
}

