/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.backend;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.network.BrokerCommandHandlerFactory;
import org.joyqueue.broker.network.backend.BrokerExceptionHandler;
import org.joyqueue.broker.network.support.BrokerTransportServerFactory;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.transport.TransportServer;
import org.joyqueue.network.transport.TransportServerFactory;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendServer
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(BackendServer.class);
    private ServerConfig config;
    private EventBus<TransportEvent> transportEventBus;
    private ExceptionHandler exceptionHandler;
    private TransportServerFactory transportServerFactory;
    private TransportServer transportServer;
    private BrokerCommandHandlerFactory commandHandlerFactory;

    public BackendServer(ServerConfig config, BrokerContext brokerContext) {
        this.config = config;
        this.transportEventBus = new EventBus("joyqueue-backend-eventBus");
        this.exceptionHandler = new BrokerExceptionHandler();
        this.commandHandlerFactory = new BrokerCommandHandlerFactory(brokerContext);
        this.transportServerFactory = new BrokerTransportServerFactory((CommandHandlerFactory)this.commandHandlerFactory, this.exceptionHandler, this.transportEventBus);
    }

    public void addListener(EventListener<TransportEvent> listener) {
        this.transportEventBus.addListener(listener);
    }

    public void removeListener(EventListener<TransportEvent> listener) {
        this.transportEventBus.removeListener(listener);
    }

    protected void doStart() throws Exception {
        this.transportEventBus.start();
        this.transportServer = this.transportServerFactory.bind(this.config, this.config.getHost(), this.config.getPort());
        this.transportServer.start();
        logger.info("backend server is started, host: {}, port: {}", (Object)this.config.getHost(), (Object)this.config.getPort());
    }

    protected void doStop() {
        this.transportEventBus.stop();
        this.transportServer.stop();
    }
}

