/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.codec;

import com.google.common.collect.Lists;
import com.jd.laf.extension.ExtensionManager;
import java.util.List;
import org.joyqueue.broker.network.codec.BrokerPayloadCodec;
import org.joyqueue.broker.network.codec.BrokerPayloadCodecRegistrar;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.CodecFactory;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.codec.PayloadCodecFactory;
import org.joyqueue.network.transport.codec.support.JoyQueueCodec;

public class BrokerCodecFactory
implements CodecFactory {
    private static final Codec CODEC_INSTANCE = new BrokerCodecFactory().getCodec();
    private PayloadCodecFactory payloadCodecFactory = this.initPayloadCodecFactory();

    protected PayloadCodecFactory initPayloadCodecFactory() {
        PayloadCodecFactory payloadCodecFactory = new PayloadCodecFactory();
        List<BrokerPayloadCodec> brokerPayloadCodecs = this.loadPayloadCodecs();
        for (BrokerPayloadCodec brokerPayloadCodec : brokerPayloadCodecs) {
            payloadCodecFactory.register((PayloadCodec)brokerPayloadCodec);
        }
        BrokerPayloadCodecRegistrar.register(payloadCodecFactory);
        return payloadCodecFactory;
    }

    protected List<BrokerPayloadCodec> loadPayloadCodecs() {
        return Lists.newArrayList((Iterable)ExtensionManager.getOrLoadExtensions(BrokerPayloadCodec.class));
    }

    public Codec getCodec() {
        return new JoyQueueCodec(this.payloadCodecFactory);
    }

    public static Codec getInstance() {
        return CODEC_INSTANCE;
    }
}

